package com.xxfc.platform.vehicle.rest;


import cn.hutool.core.util.StrUtil;
import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.admin.feign.rest.UserRestInterface;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.github.wxiaoqi.security.auth.client.jwt.UserAuthUtil;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.CommonBaseController;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

@Slf4j
public class BaseController<Biz extends BaseBiz> extends CommonBaseController implements UserRestInterface {
    
    @Autowired
    protected Biz baseBiz;

    @Autowired
    protected UserAuthConfig userAuthConfig;

    @Autowired
    private UserAuthUtil userAuthUtil;

    @Autowired
    UserFeign userFeign;

    @Override
    public UserFeign getUserFeign() {
        return userFeign;
    }

    public String getUserName()throws Exception{ return  userAuthUtil.getInfoFromToken(userAuthConfig.getToken(request)).getUniqueName(); }

    public Biz getBaseBiz() {
        return baseBiz;
    }

    public String getUserId()throws Exception{ return  userAuthUtil.getInfoFromToken(userAuthConfig.getToken(request)).getId(); }

}
