package com.xxfc.platform.vehicle.pojo;

import com.github.wxiaoqi.security.common.vo.DataInter;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
public class VehiclePageQueryVo implements DataInter {

    /**
     * 车辆编号，0-没有
     */
    private Integer code;

    /**
     * 车辆状态： 1-正常运行 2-维修 3-报废
     */
    private Integer status;

    /**
     * 车牌号，空字符串-没有
     */
    private String numberPlate;

    /**
     * 品牌（编码，对应关系见相关常量），0-未填写
     */
    private Integer brand;

    /**
     * 所属门店（id）
     */
    private Integer subordinateBranch;

    /**
     * 停靠门店
     */
    private Integer parkBranchCompanyId;

    /**
     * 所属公司
     */
    private Integer companyId;
    /**
     * 所属省份（id）
     */
    private Integer addrProvince;
    /**
     * 所属市区（id）
     */
    private Integer addrCity;

    /**
     * 片区
     */
    private Integer zoneId;

    /**
     * 用途类型：租赁房车（1）、展车等，对应关系见车辆常量表
     */
    private Integer useType;

    /**
     * 托管人
     */
    private String belongToName;
    /**
     * 预定目标日期(开始)
     */
    private String bookedStartDate;
    /**
     * 预定目标日期(结束)
     */
    private String bookedEndDate;

    /**
     * 未预定目标日期(开始)
     */
    private String notBookedStartDate;
    /**
     * 未预定目标日期(结束)
     */
    private String notBookedEndDate;

    private Integer page;

    private Integer limit;

    /**
     * 车架号
     */
    private String vin;

    /**
     * 里程数
     */
    private Integer mileageRangeStart;

    /**
     * 里程数
     */
    private Integer mileageRangeEnd;


    /**
     * 保险公司，见常量表
     */
    private Integer insuranceCompany;


    /**
     * 保险结束时间查询范围 - 开始
     */
    private Date insuranceDateRangeStart;

    /**
     * 保险结束时间查询范围 - 结束
     */
    private Date insuranceDateRangeEnd;

    /**
     * 年审日期查询范围 - 开始
     */
    private Date aVRangeDateStart;

    /**
     * 年审日期查询范围 - 结束
     */
    private Date aVRangeDateEnd;

    /**
     * 保养日期查询范围 - 开始
     */
   private Date mRangeDateStart;

    /**
     * 保养日期查询范围 - 结束
     */
    private Date mRangeDateEnd;

    /**
     * 是否违章
     */
    private Integer haveViolation;

    /**
     * 车型id
     */
    private Integer modelId;

    /**
     * 判断是否需要下载
     */
    private boolean download;

    List<Integer> dataCompanyIds;

    List<Integer> dataCorporationIds;

    Integer bizType;

}
