package com.xxfc.platform.order.rest;


import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.order.biz.OrderDetailBiz;
import com.xxfc.platform.order.pojo.dto.OrderDetailDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import java.util.List;

@RestController
@RequestMapping("chw/orderDetail")
@Slf4j
public class AppOrderDetailController{



    @Autowired
    OrderDetailBiz orderDetailBiz;


    @RequestMapping(value = "app/unauth/getOrderDetail", method = RequestMethod.GET)
    @IgnoreUserToken
    public ObjectRestResponse<List<OrderDetailDTO>> getOrderDetail(@RequestParam("orderNo")String orderNo, @RequestParam("type")Integer type) {
        return  ObjectRestResponse.succ(orderDetailBiz.getOrderDetail(orderNo,type));
    }

}
