package com.xxfc.platform.order.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;

@Data
@Table(name = "company_info")
public class CompanyInfo {
    @Id
    @GeneratedValue(generator = "JDBC")
    @ApiModelProperty("主键id")
    private Long id;

    @ApiModelProperty("app用户id")
    @Column(name = "app_user_id")
    private Integer appUserId;

    @ApiModelProperty("公司名称")
    private String name;


    @ApiModelProperty("公司类型：1-个体；2-企业")
    private Integer type;


    @ApiModelProperty("法人姓名")
    @Column(name = "legal_person")
    private String legalPerson;


    @ApiModelProperty("法人身份证")
    @Column(name = "legal_id_number")
    private String legalIdNumber;


    @ApiModelProperty("身份证正面")
    @Column(name = "front_url")
    private String frontUrl;



    @ApiModelProperty("法人身份证反面")
    @Column(name = "back_url")
    private String backUrl;



    @ApiModelProperty("联系人")
    private String contact;



    @ApiModelProperty("联系电话")
    private String mobile;


    @ApiModelProperty("营业执照")
    @Column(name = "business_license")
    private String businessLicense;


    @ApiModelProperty("合同s，逗号隔开")
    @Column(name = "contract_imgs")
    private String contractImgs;



    /**
     * 地址-省/直辖市(编码)
     */
    @Column(name = "addr_province")
    @ApiModelProperty("地址-省/直辖市(编码)")
    private Integer addrProvince;

    /**
     * 地址-省/直辖市(编码)名称
     */
    @Column(name = "province_name")
    @ApiModelProperty("地址-省/直辖市(编码)名称")
    private String provinceName;

    /**
     * 地址-市(编码)
     */
    @Column(name = "addr_city")
    @ApiModelProperty("地址-市(编码)")
    private Integer addrCity;


    /**
     * 地址-市(编码)名称
     */
    @Column(name = "city_name")
    @ApiModelProperty("地址-市(编码名称")
    private String cityName;

    /**
     * 地址-镇/县（编码）
     */
    @Column(name = "addr_town")
    @ApiModelProperty("地址-镇/县（编码）")
    private Integer addrTown;

    /**
     * 地址-县名称
     */
    @Column(name = "town_name")
    @ApiModelProperty("县名称")
    private String townName;

    /**
     * 详细地址
     */
    @Column(name = "addr_detail")
    @ApiModelProperty("详细地址")
    private String addrDetail;


    @ApiModelProperty("成立日期")
    @Column(name = "open_date")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyyMMdd",timezone="GMT+8")
    private Date openDate;


    @ApiModelProperty("营业执照有效期")
    @Column(name = "license_date")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyyMMdd",timezone="GMT+8")
    private Date licenseDate;



    @Column(name = "register_code")
    @ApiModelProperty("统一社会信用代码/注册号")
    private String registerCode;



    @Column(name = "crt_time")
    private Long crtTime;


    @Column(name = "upd_time")
    private Long updTime;


    @Column(name = "is_del")
    private Integer isDel;

}