package com.xxfc.platform.activity.rest.admin;

import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.admin.feign.rest.UserRestInterface;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.DataInterBean;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.activity.biz.CouponBiz;
import com.xxfc.platform.activity.dto.CouponDTO;
import com.xxfc.platform.activity.dto.CouponFindDTO;
import com.xxfc.platform.activity.entity.Coupon;
import com.xxfc.platform.activity.vo.CouponPagVo;
import com.xxfc.platform.activity.vo.CouponTitleVo;
import com.xxfc.platform.activity.vo.CouponVo;
import com.xxfc.platform.vehicle.feign.VehicleFeign;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_FALSE;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/23 10:39
 */
@RestController
@RequestMapping("/admin/coupon")
public class CouponAdminController implements UserRestInterface {

    @Autowired
    private CouponBiz couponBiz;

    @Autowired
    UserFeign userFeign;

    @Override
    public UserFeign getUserFeign() {
        return userFeign;
    }


    @ApiOperation("优惠券列表")
    @GetMapping("/business/page")
    public ObjectRestResponse<PageDataVO<CouponPagVo>> listBusinessCouponWithPage(CouponFindDTO couponFindDTO) {
        DataInterBean dataInterBean = getDataInter();
        couponFindDTO.setBizType(dataInterBean.getBizType());
        couponFindDTO.setCompanyIds(dataInterBean.getDataCompanyIds());
        //设置参数过滤
        PageDataVO<CouponPagVo> couponPage = couponBiz.listCouponWithPage(couponFindDTO);
        return ObjectRestResponse.succ(couponPage);
    }

    @ApiOperation("优惠券列表")
    @GetMapping("/operate/page")
    public ObjectRestResponse<PageDataVO<CouponPagVo>> listOperateCouponWithPage(CouponFindDTO couponFindDTO) {
        DataInterBean dataInterBean = getDataInter();
        couponFindDTO.setBizType(dataInterBean.getBizType());
        //设置参数过滤
        PageDataVO<CouponPagVo> couponPage = couponBiz.listCouponWithPage(couponFindDTO);
        return ObjectRestResponse.succ(couponPage);
    }

    @ApiOperation("查询优惠券详情")
    @GetMapping("/operate/{id}")
    public ObjectRestResponse<Coupon> findCouponById(@PathVariable(value = "id") Integer id){
        Coupon coupon =  couponBiz.selectByWeekend(w -> {
           w.andEqualTo(Coupon::getId, id);
           w.andEqualTo(Coupon::getIsDel, SYS_FALSE);
           return w;
       }).get(0);
       return  ObjectRestResponse.succ(coupon);
    }

    @ApiOperation("获取优惠劵标题列表")
    @GetMapping("/titles")
    public ObjectRestResponse<List<CouponTitleVo>> getCouponTitleList(){
          List<CouponTitleVo> titles = couponBiz.getCouponTitleList();
      return   ObjectRestResponse.succ(titles);
    }
    @ApiOperation("优惠劵新增 或 编辑")
    @PostMapping("/operate")
    public ObjectRestResponse<Void> addCoupon(@RequestBody CouponDTO couponDTO, UserDTO userDTO){
        couponBiz.addCoupon(couponDTO,userDTO);
        return ObjectRestResponse.succ();
    }

    @ApiOperation("优惠劵逻辑删除")
    @DeleteMapping("/operate/{id}")
    public ObjectRestResponse<Void> deleteCouponById(@PathVariable(value = "id") Integer id,UserDTO userDTO){
        couponBiz.updateCouponDelStateById(id,userDTO);
        return ObjectRestResponse.succ();
    }

    @ApiOperation("检查优惠劵是否已经在使用阶段")
    @GetMapping("check/{id}")
    public Boolean checkCouponHasUsedById(@PathVariable(value = "id") Integer id){

        return false;
    }


    @ApiOperation("优惠券列表")
    @GetMapping("/getList")
    public ObjectRestResponse<List<Coupon>> getList(CouponFindDTO couponFindDTO) {
        return ObjectRestResponse.succ(couponBiz.getList(couponFindDTO));
    }
}
