package com.xxfc.platform.activity.entity;

import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.List;

@Data
@Table(name = "activity_product")
public class ActivityProduct {
    /**
     * 主键
     */
    @Id
    private Long id;

    /**
     * 创建时间
     */
    @Column(name = "crt_time")
    private Long crtTime;

    /**
     * 更新时间
     */
    @Column(name = "upd_time")
    private Long updTime;

    /**
     * 活动名称
     */
    private String name;

    /**
     * 活动开始时间
     */
    @Column(name = "start_time")
    private Long startTime;

    /**
     * 活动结束时间
     */
    @Column(name = "end_time")
    private Long endTime;

    /**
     * 购买数量限制
     */
    @Column(name = "num_limit")
    private Integer numLimit;

    /**
     * 领取人数限制
     */
    @Column(name = "has_join_num")
    private Integer hasJoinNum;

    /**
     * 当前状态 1--上架 2--下架
     */
    private Boolean status;

    /**
     * 排序
     */
    private Boolean sort;

    /**
     * 活动图片
     */
    private String picture;

    /**
     * 类型 1--优惠券; 2--
     */
    private Boolean type;

    /**
     * 活动时期类型:0-永久,1-有期限
     */
    @Column(name = "time_type")
    private Boolean timeType;

    @Column(name = "is_del")
    private Boolean isDel;

    /**
     * 规格ID
     */
    @Column(name = "specs_id")
    private Integer specsId;

    /**
     * 销量
     */
    private Integer sales;

    /**
     * 库存
     */
    private Integer stock;

    /**
     * 详情介绍
     */
    private String detail;

    /**
     * 说明
     */
    private String explainInfo;

    @Transient
    List<ActivityProductSpecs> list;

}