package com.github.wxiaoqi.security.admin.rest;

import com.github.wxiaoqi.security.admin.biz.*;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.activity.feign.ActivityFeign;
import com.xxfc.platform.order.feign.OrderFeign;
import lombok.RequiredArgsConstructor;
import org.apache.tomcat.util.threads.ThreadPoolExecutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.PostConstruct;
import java.util.*;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/24 15:11
 */
@ConditionalOnProperty(prefix = "data.clean", name = "enable", havingValue = "true")
@RequiredArgsConstructor(onConstructor = @__({@Autowired}))
@RestController
@RequestMapping("/app/unauth/user_data")
public class DataController {

    private final AppUserLoginBiz appUserLoginBiz;

    private final AppUserDetailBiz appUserDetailBiz;

    private final AppUserRelationBiz appUserRelationBiz;

    private final AppUserSellingWaterBiz appUserSellingWaterBiz;

    private final ActivityFeign activityFeign;

    private final MyWalletBiz walletBiz;

    private final MyWalletCathBiz walletCathBiz;

    private final BaseUserMemberBiz userMemberBiz;

    private final OrderFeign orderFeign;


    @GetMapping("/clearwithphone")
    public ObjectRestResponse<Void> clearData(@RequestParam("phones") List<String> phons) {

        Map<String, Integer> phoneAndUserIdMapByPhones = appUserLoginBiz.findPhoneAndUserIdMapByPhonesForDel(phons);
        if (Objects.nonNull(phoneAndUserIdMapByPhones)) {
            Collection<Integer> userIds = phoneAndUserIdMapByPhones.values();
            //1.删除登录表信息
            appUserLoginBiz.deleteByPhones(phons);
            //2.删除用户详情信息
            appUserDetailBiz.deleteByUserIds(userIds);
            //3.删除用户关系表信息
            appUserRelationBiz.deleteByMemberIds(userIds);
            //4.删除用户钱包
            walletBiz.deleteByUserIds(userIds);
            //5.删除用户提现记录
            walletCathBiz.deleteByUserIds(userIds);
            //6.删除会员信息
            userMemberBiz.deleteByUserIds(userIds);
            //7.删除佣金数据
            appUserSellingWaterBiz.deleteByMemberIds(userIds);
            //8.清除活动和用户优惠券信息
            activityFeign.clearDate(new ArrayList(userIds));
            //9.消除租车订单与旅游订单信息
//            orderFeign.clearDateByUserIds(new ArrayList(userIds));
        }
        return ObjectRestResponse.succ();
    }

    @GetMapping("/clear_relation_withphone")
    public ObjectRestResponse<Void> clearRelationphone(@RequestParam("phones") List<String> phons) {

        Map<String, Integer> phoneAndUserIdMapByPhones = appUserLoginBiz.findPhoneAndUserIdMapByPhonesForDel(phons);
        if (Objects.nonNull(phoneAndUserIdMapByPhones)) {
            Collection<Integer> userIds = phoneAndUserIdMapByPhones.values();
            appUserRelationBiz.deleteByMemberIds(userIds);
            appUserSellingWaterBiz.deleteByMemberIds(userIds);

        }
        return ObjectRestResponse.succ();
    }
}