package com.xxfc.platform.order.biz;

import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.order.entity.OrderStatistics;
import com.xxfc.platform.order.mapper.OrderStatisticsMapper;
import com.xxfc.platform.order.pojo.HomePageOrderData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Objects;


/**
 * @author Administrator
 */
@Service
public class OrderStatisticsBiz extends BaseBiz<OrderStatisticsMapper, OrderStatistics> {
    @Autowired
    private DailyVehicleOrderStatisticsBiz vehicleBiz;


    @Autowired
    private DailyTravelOrderStatisticsBiz TravelBiz;

    @Autowired
    private DailyMembersOrderStatisticsBiz membersBiz;

    public HomePageOrderData getTotalOrder(Integer companyId) {
        HomePageOrderData result = new HomePageOrderData();
        ArrayList<HomePageOrderData> orderStatistics = new ArrayList<>();

        OrderStatistics vehicle = vehicleBiz.findAll(companyId);
        if (vehicle != null) {
            HomePageOrderData data = new HomePageOrderData() {{
                setTotalOrders(vehicle.getTotalGmv().subtract(vehicle.getTotalReturnGmv()));
                setAdditionalIndemnity(vehicle.getTotalCompensation()
                        .add(vehicle.getTotalForfeit())
                        .add(vehicle.getTotalDefaultMoney())
                        .add(vehicle.getTotalExpenditure().subtract(vehicle.getTotalGmv().subtract(vehicle.getTotalReturnGmv())))
                );
            }};
            orderStatistics.add(data);
        }
        OrderStatistics tour = TravelBiz.findAll(companyId);

        if (vehicle != null) {
            HomePageOrderData data = new HomePageOrderData() {{
                setTotalOrders(tour.getTotalGmv().subtract(tour.getTotalReturnGmv()));
                setAdditionalIndemnity(tour.getTotalDefaultMoney());
            }};
            orderStatistics.add(data);
        }
        OrderStatistics member = membersBiz.findAll(companyId);
        if (vehicle != null) {
            HomePageOrderData data = new HomePageOrderData() {{
                setTotalOrders(member.getTotalGmv());

            }};
            orderStatistics.add(data);
        }




        result.setTotalOrders(orderStatistics.stream().map(HomePageOrderData::getTotalOrders).filter(o-> Objects.nonNull(o)).reduce(BigDecimal.ZERO, BigDecimal::add));

        result.setTotalOutstandingDeposit(orderStatistics.stream().map(HomePageOrderData::getTotalOutstandingDeposit).filter(o-> Objects.nonNull(o)).reduce(BigDecimal.ZERO, BigDecimal::add));

        result.setAdditionalIndemnity(orderStatistics.stream().map(HomePageOrderData::getAdditionalIndemnity).filter(o-> Objects.nonNull(o)).reduce(BigDecimal.ZERO, BigDecimal::add));

        return result;
    }

}
