package com.xxfc.platform.order.contant.enumerate;

import java.util.HashMap;
import java.util.Map;

public enum AccountTypeEnum {
    //账款类型 1*--入账；2*--出账
    //账款类型 记帐类型 101--订单支付；201--取消订单退款；202--全部押金退款；203--部分押金退款；204--剩余押金退款
    IN_ORDER_PAY(101, "订单支付"),
    OUT_ORDER_FUND(201, "订单款"),
    OUT_DEPOSIT(202, "所有押金"),
    OUT_PART_DEPOSIT(203, "部分押金（扣除该扣除的 + 保留违章预备金）"),
    OUT_RESIDUE_DEPOSIT(204, "剩余押金（扣除该扣除的）"),
    ;
    /**
     * 编码
     */
    private Integer code;
    /**
     * 类型描述
     */
    private String desc;

    private static Map<Integer,String> codeAndDesc = new HashMap<Integer, String>();
            //Maps.newHashMap();

    static{
        for(AccountTypeEnum enumE : AccountTypeEnum.values()){
            codeAndDesc.put(enumE.getCode(),enumE.getDesc());
        }
    }

    AccountTypeEnum(Integer code, String desc){
        this.code=code;
        this.desc=desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static Boolean exists(Integer code){
        return codeAndDesc.containsKey(code);
    }
}