package com.xxfc.platform.vehicle.pojo.dto;


import com.xxfc.platform.vehicle.entity.VehiclePublish;
import com.xxfc.platform.vehicle.entity.VehiclePublishReceive;
import com.xxfc.platform.vehicle.pojo.vo.VehiclePublishReceiveVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/8/23 16:27
 */
@Data
public class VehiclePublishReceiveDTO{

    public static final int ADD=0;//接单添加
    public static final int PAY=1;//接单支付
    public static final int REFUSE=2;//确认全部拒绝
    public static final int AGREE=3;//确认
    public static final int CANCEL=4;//取消
    public static final int COLLECT=5;//收车

    @ApiModelProperty("需求Id")
    private Integer  publishId;



    @ApiModelProperty("类型：1-接单者；2-发布者")
    private Integer  type;


    @ApiModelProperty("接单公司Id")
    private Integer  companyId;


    @ApiModelProperty("接单用户Id")
    private Integer  userId;


    List<Integer> ids;


    @ApiModelProperty(value = "接单ids(逗号隔开)")
    private String receiveIds;


    @ApiModelProperty(value = "拒绝的接单ids")
    private String refuseReceiveIds;



    private Integer status;


    @ApiModelProperty("需求详情")
    VehiclePublish vehiclePublish;


    @ApiModelProperty("接单详情")
    List<VehiclePublishReceiveVo> receiveVos;


    private String orderNo;


    private BigDecimal goodsAmount;


    private BigDecimal payAmount;


    private  Long nowTime;


    public  Long getNowTime(){
        return  System.currentTimeMillis();
    }


}
