package com.xxfc.platform.order.rest;

import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.common.context.BaseContextHandler;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.order.biz.OrderPulishReceiveDetailBiz;
import com.xxfc.platform.order.entity.BaseOrder;
import com.xxfc.platform.order.entity.OrderPulishReceiveDetail;
import com.xxfc.platform.order.pojo.order.PulishReceiveBO;
import com.xxfc.platform.order.service.OrderPulishReceiveService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

@Controller
@RequestMapping("chw/orderPulishReceive")
@Api(value = "调车需求订单", tags = {"调车需求订单"})
@IgnoreClientToken
public class OrderPulishReceiveController extends BaseController<OrderPulishReceiveDetailBiz, OrderPulishReceiveDetail> {

    @Autowired
    OrderPulishReceiveService receiveService;

    @Autowired
    UserFeign userFeign;

    @RequestMapping(value = "add", method = RequestMethod.POST)
    @ResponseBody
    @ApiOperation(value = "确认订单")
    public ObjectRestResponse<BaseOrder> add(@RequestBody PulishReceiveBO bo) {
        bo.setAppUserDTO(userFeign.userDetailByToken(BaseContextHandler.getToken()).getData());
        //查询优惠券
        receiveService.createOrder(bo);
        return ObjectRestResponse.succ(bo.getOrder());
    }
}