package com.github.wxiaoqi.security.admin.rest;

import com.github.wxiaoqi.security.admin.biz.BaseOrderRevenueBiz;
import com.github.wxiaoqi.security.admin.dto.BaseOrderRevenueFindDTO;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author Administrator
 */
@Slf4j
@RestController
@RequestMapping("app/revenue")
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
@Api(tags = {"营收明细"})
public class AppOrderRevenueController extends BaseController<BaseOrderRevenueBiz> {






    @GetMapping("selectList")
    @ApiModelProperty("列表")
    public  ObjectRestResponse selectList(BaseOrderRevenueFindDTO orderRevenueFindDTO) {
        if (orderRevenueFindDTO.getCompanyId() == null || orderRevenueFindDTO.getCompanyId() == 0){
            List<Integer> companyIds = getBusinessUserCompanyIds();
            if (companyIds != null && companyIds.size() > 0){
                orderRevenueFindDTO.setCompanyId(companyIds.get(0));
            }
        }
        return ObjectRestResponse.succ(baseBiz.selectList(orderRevenueFindDTO));
    }


    @GetMapping("sumAmount")
    @ApiModelProperty("总营收")
    public  ObjectRestResponse sumAmount(BaseOrderRevenueFindDTO orderRevenueFindDTO) {
        if (orderRevenueFindDTO.getCompanyId() == null || orderRevenueFindDTO.getCompanyId() == 0){
            List<Integer> companyIds = getBusinessUserCompanyIds();
            if (companyIds != null && companyIds.size() > 0){
                orderRevenueFindDTO.setCompanyId(companyIds.get(0));
            }
        }
        return ObjectRestResponse.succ(baseBiz.sumAmount(orderRevenueFindDTO));
    }



}
