package com.github.wxiaoqi.security.admin.constant.enumerate;

import java.util.HashMap;
import java.util.Map;

public enum CompanyWalletITypeEnum {
    COMPANY(1, "订单收入"),
    REGULATION(2, "违章收入"),
    CATH(3, "订单提现"),
    REGULATION_CATH(4, "违章提现"),
    ;
    /**
     * 编码
     */
    private Integer code;
    /**
     * 类型描述
     */
    private String desc;

    public static Map<Integer, CompanyWalletITypeEnum> codeAndDesc = new HashMap<Integer, CompanyWalletITypeEnum>();
            //Maps.newHashMap();

    static{
        for(CompanyWalletITypeEnum enumE : CompanyWalletITypeEnum.values()){
            codeAndDesc.put(enumE.getCode(), enumE);
        }
    }

    CompanyWalletITypeEnum(Integer code, String desc){
        this.code=code;
        this.desc=desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static Boolean exists(Integer code){
        return codeAndDesc.containsKey(code);
    }

    public static CompanyWalletITypeEnum get(Integer code) {
        for(CompanyWalletITypeEnum enumE : CompanyWalletITypeEnum.values()) {
            if (enumE.getCode().equals(code)) {
                return enumE;
            }
        }
        return null;
    }
}