package com.xxfc.platform.campsite.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 营地店铺表
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-06-17 10:28:48
 */
@Data
@Table(name = "campsite_shop")
public class CampsiteShop implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @Id
    @GeneratedValue(generator = "JDBC")
    @ApiModelProperty("主键id")
    private Integer id;

    /**
     * 店铺名称
     */
    @Column(name = "name")
    @ApiModelProperty(value = "店铺名称")
    private String name;

    /**
     * 店铺logo
     */
    @Column(name = "logo")
    @ApiModelProperty(value = "店铺logo")
    private String logo;

    /**
     * 店铺介绍
     */
    @Column(name = "intro")
    @ApiModelProperty(value = "店铺介绍")
    private String intro;

    /**
     * 店铺URL
     */
    @Column(name = "url")
    @ApiModelProperty(value = "店铺URL")
    private String url;

    /**
     * 主要联系人
     */
    @Column(name = "concat")
    @ApiModelProperty(value = "主要联系人")
    private String concat;

    /**
     * 联系人身份证号
     */
    @Column(name = "id_number")
    @ApiModelProperty(value = "联系人身份证号")
    private String idNumber;

    /**
     * 联系人电话
     */
    @Column(name = "phone")
    @ApiModelProperty(value = "联系人电话")
    private String phone;

    /**
     * 公司id
     */
    @Column(name = "company_id")
    @ApiModelProperty(value = "公司id")
    private Integer companyId;

    /**
     * 公司名称
     */
    @Column(name = "company_name")
    @ApiModelProperty(value = "公司名称")
    private String companyName;

    /**
     * 开店时间
     */
    @Column(name = "start_time")
    @ApiModelProperty(value = "开店时间")
    private Long startTime;

    /**
     * 地址-省/直辖市(编码)
     */
    @Column(name = "province")
    @ApiModelProperty(value = "地址-省/直辖市(编码)")
    private Integer province;

    /**
     * 地址-省/直辖市(名称)
     */
    @Column(name = "province_name")
    @ApiModelProperty(value = "地址-省/直辖市(名称)")
    private String provinceName;

    /**
     * 地址-市
     */
    @Column(name = "city")
    @ApiModelProperty(value = "地址-市")
    private Integer city;

    /**
     * 地址-市(名称)
     */
    @Column(name = "city_name")
    @ApiModelProperty(value = "地址-市(名称)")
    private String cityName;

    /**
     * 经度
     */
    @Column(name = "longitude")
    @ApiModelProperty(value = "经度")
    private Double longitude;

    /**
     * 纬度
     */
    @Column(name = "latitude")
    @ApiModelProperty(value = "纬度")
    private Double latitude;

    /**
     * 具体地址
     */
    @Column(name = "address")
    @ApiModelProperty(value = "具体地址")
    private String address;

    /**
     * 客服电话
     */
    @Column(name = "service_phone")
    @ApiModelProperty(value = "客服电话")
    private String servicePhone;

    /**
     * 配套设施&收费
     */
    @Column(name = "configure")
    @ApiModelProperty(value = "配套设施&收费")
    private String configure;

    /**
     * 店铺详情
     */
    @Column(name = "content")
    @ApiModelProperty(value = "店铺详情")
    private String content;

    /**
     * 店铺状态:0-未开业；1-已开业
     */
    @Column(name = "status")
    @ApiModelProperty(value = "店铺状态:0-未开业；1-已开业")
    private Integer status;

    /**
     * 创建时间
     */
    @Column(name = "crt_time")
    @ApiModelProperty(value = "创建时间", hidden = true)
    private Long crtTime;

    /**
     * 更新时间
     */
    @Column(name = "upd_time")
    @ApiModelProperty(value = "更新时间", hidden = true)
    private Long updTime;

    /**
     * 是否删除：0-正常；1-删除
     */
    @Column(name = "is_del")
    @ApiModelProperty(value = "是否删除：0-正常；1-删除")
    private Integer isDel;

    /**
     * 热度值
     */
    @Column(name = "hot")
    @ApiModelProperty(value = "热度值")
    private Integer hot;

    /**
     * 上下架状态 0-创建状态  1-上架 2-下架
     */
    @Column(name = "sale_state")
    @ApiModelProperty(value = "上下架状态 0-创建状态  1-上架 2-下架")
    private Integer saleState;

    @Column(name = "poster_background")
    @ApiModelProperty(value = "海报背景")
    private String posterBackground;
}
