package com.xxfc.platform.vehicle.pojo;

import com.github.wxiaoqi.security.common.vo.PageParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Map;

import static com.github.wxiaoqi.security.common.constant.CommonConstants.DATE_TIME_LINE_FORMATTER;
import static com.github.wxiaoqi.security.common.constant.CommonConstants.YMR_SLASH_FORMATTER;

@Data
public class RentVehicleBookDTO extends PageParam {
    //根据车型、时间、距离，门店，预定车辆
    @ApiModelProperty("车型id")
    private Integer modelId;
    /**
     * 预定目标日期(开始)
     */
    @ApiModelProperty("预定目标日期(开始)")
    private String bookStartDate;

    /**
     * 预定目标日期(结束)
     */
    @ApiModelProperty("预定目标日期(结束)")
    private String bookEndDate;

    /**
     * 预定目标日期(开始)
     */
    @ApiModelProperty("预定目标时间(开始)")
    private String bookStartDateTime;

    /**
     * 预定目标日期(结束)
     */
    @ApiModelProperty("预定目标时间(结束)")
    private String bookEndDateTime;


    /**
     * 提车地点
     */
    @ApiModelProperty("提车地点")
    private String liftAddr;

    /**
     * 提车公司
     */
    @ApiModelProperty("提车公司")
    private Integer liftCompany;

    /**
     * 还车分公司
     */
    @ApiModelProperty("还车分公司")
    private Integer retCompany;

    /**
     * 目的地
     */
    @ApiModelProperty("目的地")
    private String destination;

    /**
     *  用户名
     */
    @ApiModelProperty("用户名")
    private String userName;

    @ApiModelProperty("订单号")
    private String orderNo;

    @ApiModelProperty("指定车牌")
    String numberPlate;

    @ApiModelProperty("指定预约状态")
    Integer status;

    /**
     * 随车物品id以及数量 List<Map<id,数量>>
     */
    @ApiModelProperty("随车物品id以及数量 List<Map<id,数量>>")
    Map<Integer,Integer> selectedAccItem;

    @ApiModelProperty("停靠公司id")
    Integer parkBranchCompanyId;

    @ApiModelProperty("开始公司id")
    Integer startCompanyId;

    @ApiModelProperty("结束公司id")
    Integer endCompanyId;

    @ApiModelProperty("扩展开始时间")
    String startDateExtend;

    @ApiModelProperty("扩展结束时间")
    String endDateExtend;

    /**
     * 用途 1 租车
     */
    @ApiModelProperty(hidden = true)
    Integer useType = 1;

    public void setBookStartDate(String bookStartDate) {
        this.bookStartDate = bookStartDate;
        //首次设置
        if(null == this.startDateExtend) {
            this.startDateExtend = YMR_SLASH_FORMATTER.format(LocalDate.parse(bookStartDate, YMR_SLASH_FORMATTER).minusDays(1L));
        }
    }

    public void setBookEndDate(String bookEndDate) {
        this.bookEndDate = bookEndDate;
        //首次设置
        if(null == this.endDateExtend) {
            this.endDateExtend = YMR_SLASH_FORMATTER.format(LocalDate.parse(bookEndDate, YMR_SLASH_FORMATTER).plusDays(1L));
        }
    }
}