package com.xxfc.platform.universal.controller;




import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.UserAgentUtil;
import com.xxfc.platform.universal.biz.OrderPayBiz;
import com.xxfc.platform.universal.biz.WeixinService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletRequest;

/**
 * 用户
 */
@RestController
@RequestMapping("info")
@IgnoreUserToken
@Slf4j
public class UserInfoController {


    @Autowired
    WeixinService weixinService;

    @Autowired
    OrderPayBiz orderPayBiz;

    @Value("${wx.sendUrl}")
    private String  sendUrl;


    @RequestMapping(value = "getOpenId", method = RequestMethod.GET) //匹配的是href中的download请求
    public ObjectRestResponse getOpenId(HttpServletRequest request) throws Exception {
        boolean isWx = UserAgentUtil.isWexinBrowser(request);
        if (isWx) {
            //session里面获取用户信息
            String openId=weixinService.getSession(request);
            log.info("---进入方法getOpenId----openId===="+openId);
            if (StringUtils.isBlank(openId)){
                JSONObject json = new JSONObject();
                json.put("sendUrl",sendUrl);

                return  ObjectRestResponse.createFailedResultWithObj(1001,"",json);
            }

            return ObjectRestResponse.succ(openId);
        }
        return ObjectRestResponse.succ();
    }

    @GetMapping("/app/unauth/getAliPayUserInfo")
    public ObjectRestResponse<String> getAliPayUserInfo(String code) {
        try {
            return ObjectRestResponse.succ(orderPayBiz.getAlipayToken(code));
        } catch (AlipayApiException e) {
            e.printStackTrace();
        }
        return ObjectRestResponse.createDefaultFail();
    }

    @GetMapping("/app/unauth/alipayUserAuth")
    public ObjectRestResponse<String> alipayUserAuth() {
        try {
            JSONObject jsonObject = JSONObject.parseObject(orderPayBiz.alipayUserAuth());
            return ObjectRestResponse.succ(jsonObject);
        } catch (AlipayApiException e) {
            e.printStackTrace();
        }
        return ObjectRestResponse.createDefaultFail();
    }

    @GetMapping("/app/unauth/getParam")
    public ObjectRestResponse<String> getParam(String apiName, String appName) {
            return ObjectRestResponse.succ(orderPayBiz.generateAliPayInfo(apiName, appName));
    }

}

