package com.xxfc.platform.activity.biz;

import com.xxfc.platform.activity.dto.ActivityPopularizeRelationDTO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import com.xxfc.platform.activity.entity.ActivityPopularizeRelation;
import com.xxfc.platform.activity.mapper.ActivityPopularizeRelationMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;

import java.util.ArrayList;
import java.util.List;

/**
 * 活动的参与者关系表
 *
 * @author zjw
 * @email 18178966185@163.com
 * @date 2019-07-17 19:51:17
 */
@Service
public class ActivityPopularizeRelationBiz extends BaseBiz<ActivityPopularizeRelationMapper,ActivityPopularizeRelation> {

    public List<ActivityPopularizeRelationDTO> findActivityPopularizeRelationsByActivityIdAndTime(Integer activityId, Long startTime, Long endTime) {
         List<ActivityPopularizeRelationDTO> activityPopularizeRelationDTOS = new ArrayList<>();
        List<ActivityPopularizeRelationDTO> relations = mapper.findActivityPopularizeRelationsByActivityIdAndTime(activityId, startTime, endTime);
        if (CollectionUtils.isNotEmpty(relations)){
            activityPopularizeRelationDTOS.addAll(relations);
        }
        return activityPopularizeRelationDTOS;
    }
}