package com.github.wxiaoqi.security.admin.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 用户身份职位表
 * 
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-07-09 10:00:42
 */
@Data
@Table(name = "app_user_position")
public class AppUserPosition implements Serializable {
	private static final long serialVersionUID = 1L;

	    /**
    *  主键id
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键id")
    private Integer id;
	
	    /**
     *  角色名称
     */
    @Column(name = "name")
	@ApiModelProperty(value = "角色名称")
    private String name;
	
	    /**
     *  等级
     */
    @Column(name = "level")
	@ApiModelProperty(value = "等级")
    private Integer level;
	
	    /**
     *  每年赠送的天数
     */
    @Column(name = "number")
	@ApiModelProperty(value = "每年赠送的天数")
    private Integer number;
	
	    /**
     *  提成比例
     */
    @Column(name = "extract")
	@ApiModelProperty(value = "提成比例")
    private Integer extract;
	
	    /**
     *  状态：0-正常；1-禁用
     */
    @Column(name = "status")
	@ApiModelProperty(value = "状态：0-正常；1-禁用")
    private Integer status;
	
	    /**
     *  创建时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;
	
	    /**
     *  更新时间
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;
	
	    /**
     *  是否删除：0-正常；1-删除
     */
    @Column(name = "is_del")
	@ApiModelProperty(value = "是否删除：0-正常；1-删除")
    private Integer isDel;
	

}
