package com.xxfc.platform.campsite.biz;

import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.xxfc.platform.campsite.dto.CampsiteShopCarouselDTO;
import com.xxfc.platform.campsite.dto.CampsiteShopCarouselDetailDTO;
import com.xxfc.platform.campsite.entity.CampsiteShopCarousel;
import com.xxfc.platform.campsite.mapper.CampsiteShopCarouselMapper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 店铺轮播表
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-06-17 10:28:48
 */
@Service
@Slf4j
public class CampsiteShopCarouselBiz extends BaseBiz<CampsiteShopCarouselMapper,CampsiteShopCarousel> {

    /**
     * 根据店铺id查询轮播图
     * @param id
     * @return
     */
    public List<CampsiteShopCarouselDetailDTO> findByCampsiteShopId(Integer id) {
        return mapper.findAllCarousesByShopId(id);
    }

    /**
     * 批量保存
     * @param carouselDTOS
     * @return
     */
    @Transactional(rollbackFor = Exception.class,propagation = Propagation.REQUIRED)
    public int saveBatch(List<CampsiteShopCarouselDTO> carouselDTOS,Integer shopId) {
        List<Integer> ids =null;
        List<CampsiteShopCarouselDTO> shopCarouselDTOS=null;
        if (CollectionUtils.isNotEmpty(carouselDTOS)){
            ids = carouselDTOS.stream().filter(campsiteShopCarouselDTO -> Objects.nonNull(campsiteShopCarouselDTO.getId())).map(CampsiteShopCarouselDTO::getId).collect(Collectors.toList());
            shopCarouselDTOS = carouselDTOS.stream()
                    .filter(campsiteShopCarouselDTO -> Objects.isNull(campsiteShopCarouselDTO.getId()))
                    .collect(Collectors.toList());
        }
        if (log.isDebugEnabled()){
            log.debug("更新的营地id:【{}】的轮播图信息id:【{}】",shopId,ids);
        }
        int effectRows = mapper.updateCarouseStatusByIdsAndShopId(ids, shopId, 1);
        if (CollectionUtils.isEmpty(shopCarouselDTOS)){
            return effectRows;
        }
        if (log.isDebugEnabled()){
            log.debug("保存营地id:【{}】的轮播图信息：【{}】",shopId,shopCarouselDTOS);
        }
        return  mapper.saveBatch(shopCarouselDTOS);
    }
}