/*
 * Decompiled with CFR 0.152.
 */
package ytx.org.apache.http.impl.io;

import java.io.IOException;
import java.io.InputStream;
import ytx.org.apache.http.annotation.NotThreadSafe;
import ytx.org.apache.http.io.BufferInfo;
import ytx.org.apache.http.io.SessionInputBuffer;

@NotThreadSafe
public class IdentityInputStream
extends InputStream {
    private final SessionInputBuffer in;
    private boolean closed = false;

    public IdentityInputStream(SessionInputBuffer in) {
        if (in == null) {
            throw new IllegalArgumentException("Session input buffer may not be null");
        }
        this.in = in;
    }

    @Override
    public int available() throws IOException {
        if (this.in instanceof BufferInfo) {
            return ((BufferInfo)((Object)this.in)).length();
        }
        return 0;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            return -1;
        }
        return this.in.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            return -1;
        }
        return this.in.read(b, off, len);
    }
}

