package com.github.wxiaoqi.security.admin.rest;

import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import com.github.wxiaoqi.security.admin.biz.AppUserDetailBiz;
import com.github.wxiaoqi.security.admin.biz.AppUserLoginBiz;
import com.github.wxiaoqi.security.admin.biz.AppUserManageBiz;
import com.github.wxiaoqi.security.admin.constant.Status;
import com.github.wxiaoqi.security.admin.dto.AppUserManageDTO;
import com.github.wxiaoqi.security.admin.entity.AppUserLogin;
import com.github.wxiaoqi.security.admin.entity.AppUserManage;
import com.github.wxiaoqi.security.admin.entity.User;
import com.github.wxiaoqi.security.admin.rpc.service.AppPermissionService;
import com.github.wxiaoqi.security.admin.vo.AppUserManageVo;
import com.github.wxiaoqi.security.admin.vo.AppUserVo;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.github.wxiaoqi.security.auth.client.jwt.UserAuthUtil;
import com.github.wxiaoqi.security.auth.common.util.jwt.IJWTInfo;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.util.process.SystemConfig;
import com.xxfc.platform.vehicle.feign.VehicleFeign;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Set;

/**
 * app用户管理类
 * @author Administrator
 */
@Slf4j
@RestController
@RequestMapping("appUsersManage")
public class AppUsersManageController extends BaseController<AppUserManageBiz,AppUserManage> {

    @Autowired
    private AppUserLoginBiz appUserLoginBiz;

    @Autowired
    private AppPermissionService appPermissionService;

    @Autowired
    private AppUserDetailBiz appUserDetailBiz;

    @Autowired
    protected UserAuthConfig userAuthConfig;

    @Autowired
    private PublicController publicController;

    @Autowired
    private VehicleFeign vehicleFeign;

    @Autowired
    private UserAuthUtil userAuthUtil;


    private Integer ALL_PERMISSIONS=1;
    /**
     * 查询所有
     * @return
     */
    @PostMapping("/findAll")
    public ObjectRestResponse<PageInfo<AppUserManageVo>> findAllByQuery(@RequestBody AppUserManageDTO appUserManageDTO) throws Exception {
        String token = userAuthConfig.getToken(request);
        ObjectRestResponse objectRestResponse = publicController.userinfoByToken(token);
        User  user  = (User) objectRestResponse.getData();
        if (user==null){
            throw new BaseException("User error!");
        }
        if (ALL_PERMISSIONS.equals(user.getDataAll())) {
            return ObjectRestResponse.succ(baseBiz.findAllByQuery(appUserManageDTO));
        }
        ObjectRestResponse<Set<Integer>> setObjectRestResponse = vehicleFeign.corporationCity(user.getDataZone(), user.getDataCompany());
        Set<Integer> cityList =  setObjectRestResponse.getData();
        appUserManageDTO.setCitySet(cityList);
        return  ObjectRestResponse.succ(baseBiz.findAllByQueryAndCity(appUserManageDTO));
    }

    /**
     * 根据用户id获取用户详情
     * @param userId
     * @return
     */
    @GetMapping("/user_info/{id}")
    public ObjectRestResponse<AppUserManageVo> findUserInfo(@PathVariable(value = "id") Integer userId){
         AppUserManageVo appUserManageVo = baseBiz.findUserInfoById(userId);
         return ObjectRestResponse.succ(appUserManageVo);
    }
    /**
     * 查询一条
     * @param id
     * @return
     */
    @GetMapping("/findOneById/{id}")
    public ObjectRestResponse<AppUserVo> findOneById(@PathVariable Integer id){
        return ObjectRestResponse.succ(baseBiz.findOneById(id));
    }

    /**
     * 保存
     * @param appUserVo
     * @return
     */
    @PostMapping("/save")
    public ObjectRestResponse save(@RequestBody AppUserVo  appUserVo){
        baseBiz.save(appUserVo);
        return ObjectRestResponse.succ();
    }

    /**
     * 禁用
     * @param appUserId
     * @return
     */
    @PutMapping("/disable/{appUserId}")
    public ObjectRestResponse disable(@PathVariable("appUserId") Integer appUserId){
        AppUserLogin appUserLogin = new AppUserLogin();
        appUserLogin.setStatus(Status.FORBIDDEN);
        appUserLogin.setId(appUserId);
        appUserLoginBiz.disable(appUserLogin);
        return ObjectRestResponse.succ();
    }

    /**
     * 取消禁用
     * @param appUserId
     * @return
     */
    @PutMapping("/available/{appUserId}")
    public ObjectRestResponse available(@PathVariable("appUserId") Integer appUserId){
        AppUserLogin appUserLogin = new AppUserLogin();
        appUserLogin.setStatus(Status.AVAILABLE);
        appUserLogin.setId(appUserId);
        appUserLoginBiz.available(appUserLogin);
        return ObjectRestResponse.succ();
    }

    /**
     * 删除用户
     * @param id
     * @return
     */
    @DeleteMapping("/deleteById/{id}")
    public ObjectRestResponse deleteById(@PathVariable Integer id){
        appUserLoginBiz.deleteAppUserById(id);
        return ObjectRestResponse.succ();
    }

    @PutMapping("/user_position")
    public ObjectRestResponse<Void> setUserPositionById(@RequestParam("id") Integer id, @RequestParam("positionId") Integer positionId, HttpServletRequest request) {
        try {
            IJWTInfo infoFromToken = userAuthUtil.getInfoFromToken(userAuthConfig.getToken(request));
            Integer operatorId = Integer.valueOf(infoFromToken.getId());
            appUserLoginBiz.updateUserPosition(id, positionId,operatorId);
            return ObjectRestResponse.succ();
        } catch (Exception e) {
            log.error("修改失败【{}】", e);
            throw new BaseException("修改失败");
        }
    }

    /**
     * 注册
     * @param username
     * @return
     */
    @RequestMapping(value = "app/unauth/register", method = RequestMethod.POST)
    @IgnoreUserToken
    public @ResponseBody
    JSONObject register(
            @RequestParam(value="username",defaultValue="")String  username
    ){
        //默认昵称
        String nickname= SystemConfig.USER_NIKENAME_DEFAULT+(int)((Math.random()*9+1)*100000);
        String headimgurl=SystemConfig.USER_HEADER_URL_DEFAULT;
        try {
        return appPermissionService.adminRegister(username,  username,headimgurl,
                 nickname, null,-1);
        } catch (Exception e) {
            log.error("修改失败【{}】", e);
            throw new BaseException("修改失败");
        }
    }

}

