package com.xxfc.platform.uccn.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.uccn.biz.ArticleBiz;
import com.xxfc.platform.uccn.entity.Article;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

/**
 * 文章
 *
 * @author Administrator
 */
@RestController
@RequestMapping("/article")
@Api(tags = {"文章"})
public class ArticleController extends BaseController<ArticleBiz, Article> {

    @GetMapping("/list")
    @ApiOperation(value = "获取文章列表")
    public ObjectRestResponse getArticleList(
            @RequestParam(name = "page", defaultValue = "1") Integer page,
            @RequestParam(name = "limit", defaultValue = "10") Integer limit,
            @RequestParam(name = "type", defaultValue = "0") Integer type) {
        return ObjectRestResponse.succ(baseBiz.getArticleList(page, limit, type));
    }

    @GetMapping("/one/{id}")
    @ApiOperation(value = "获取一条数据")
    public ObjectRestResponse getOne(@PathVariable Integer id) {
       return ObjectRestResponse.succ(baseBiz.getOne(id));
    }


    @GetMapping("/three/{type}")
    @ApiOperation(value = "随机获取三条数据")
    public ObjectRestResponse randomAccessToThreeData(@PathVariable Integer type){
        return ObjectRestResponse.succ(baseBiz.getThree(type));
    }

    @GetMapping("/homePage/{type}")
    @ApiOperation(value = "获取首页文章列表")
    public ObjectRestResponse getHomePageArticle(@PathVariable Integer type){
        return ObjectRestResponse.succ(baseBiz.getHomePageArticle(type));
    }
}
