package com.xxfc.platform.vehicle.biz;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.order.contant.enumerate.OrderTypeEnum;
import com.xxfc.platform.order.feign.OrderFeign;
import com.xxfc.platform.order.pojo.order.OrderPageVO;
import com.xxfc.platform.vehicle.constant.ResCode.ResCode;
import com.xxfc.platform.vehicle.constant.VehicleCountType;
import com.xxfc.platform.vehicle.entity.VehicleCountRecord;
import com.xxfc.platform.vehicle.mapper.VehicleCountRecordMapper;
import com.xxfc.platform.vehicle.pojo.ExcelParamDto;
import com.xxfc.platform.vehicle.pojo.VehicleBookRecordVo;
import com.xxfc.platform.vehicle.util.excel.ExcelExport;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 统计出车，交车数量
 */
@Slf4j
@Service
public class VehicleCountRecordBiz extends BaseBiz<VehicleCountRecordMapper, VehicleCountRecord> {

    public static final DateTimeFormatter DEFAULT_DATE_TIME_FORMATTER = DateTimeFormat.forPattern("yyyy-MM-dd");
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss");

    @Autowired
    VehicleBookRecordBiz vehicleBookRecordBiz;
    @Autowired
    VehicleDepartureService vehicleDepartureService;
    @Autowired
    OrderFeign orderFeign;

    /**
     * 获取统计出车记录
     *
     * @param vehicleCountRecord
     * @return
     */
    public ObjectRestResponse countDepartureVehicle(VehicleCountRecord vehicleCountRecord) {
        Map<String, Object> map = new HashMap<>();
        if (vehicleCountRecord.getType() != null) {
            map.put("type", vehicleCountRecord.getType());
        }
        if (StringUtils.isNotBlank(vehicleCountRecord.getStartTime())) {

            if (StringUtils.isBlank(vehicleCountRecord.getEndTime())) {
                vehicleCountRecord.setEndTime(vehicleCountRecord.getStartTime());
            }
            map.put("startTime", DateTime.parse(vehicleCountRecord.getStartTime(), DEFAULT_DATE_TIME_FORMATTER).getMillis());
            map.put("endTime", DateTime.parse(vehicleCountRecord.getEndTime(), DEFAULT_DATE_TIME_FORMATTER).getMillis());
        }

       if (MapUtils.isNotEmpty(map)) {
           List<VehicleCountRecord> list = mapper.selectByTypeAndTime(map);
           if (list == null) {
               return ObjectRestResponse.createFailedResult(ResCode.FIND_DATA_NOT_EXIST.getCode(), ResCode.FIND_DATA_NOT_EXIST.getDesc());
           }
           return ObjectRestResponse.succ(list);
       }
        return ObjectRestResponse.succ(new ArrayList<>());
    }

    public ObjectRestResponse selectByTime(VehicleCountRecord vehicleCountRecord) {
        Map<String, Object> map = new HashMap<>();
        if (vehicleCountRecord.getType() != null) {
            map.put("type", vehicleCountRecord.getType());
        }
        if (StringUtils.isNotBlank(vehicleCountRecord.getStartTime())) {

            if (StringUtils.isBlank(vehicleCountRecord.getEndTime())) {
                vehicleCountRecord.setEndTime(vehicleCountRecord.getStartTime());
            }
            map.put("startTime", DateTime.parse(vehicleCountRecord.getStartTime(), DEFAULT_DATE_TIME_FORMATTER).toDate());
            map.put("endTime", DateTime.parse(vehicleCountRecord.getEndTime(), DEFAULT_DATE_TIME_FORMATTER).toDate());
        }
        if (MapUtils.isNotEmpty(map)) {
            List<VehicleCountRecord> list = mapper.selectByTime(map);
            if (list == null) {
                return ObjectRestResponse.createFailedResult(ResCode.FIND_DATA_NOT_EXIST.getCode(), ResCode.FIND_DATA_NOT_EXIST.getDesc());
            }
            return ObjectRestResponse.succ(list);
        }
        return ObjectRestResponse.succ(new ArrayList<>());
    }

    /**
     * 添加统计记录
     *
     * @return
     */
    public void addAll() {
        Long nowTime = getDayStart();
        Long lastTime = nowTime + 24 * 3600 * 1000 - 1;
        Date startTime = new Date();
        startTime.setTime(nowTime);
        Date endTime = new Date();
        endTime.setTime(lastTime);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String startDate = null;
        String endDate = null;
        try {
            startDate = simpleDateFormat.format(startTime);
            endDate = simpleDateFormat.format(endTime);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        DateTime startDay = DateTime.parse(startDate, DEFAULT_DATE_TIME_FORMATTER);
        DateTime endDay = DateTime.parse(endDate, DEFAULT_DATE_TIME_FORMATTER);
        int i = 0;
        int monthDay = endDay.getDayOfMonth() - startDay.getDayOfMonth() + 1;
        for (DateTime curDate = startDay; i < monthDay; curDate = curDate.minusDays(1)) {
            i++;
            nowTime = curDate.getMillis();
            lastTime = nowTime + 24 * 3600 * 1000 - 1;
            startTime.setTime(nowTime);
            endTime.setTime(lastTime);
            Date nowDate = curDate.toDate();
            VehicleCountRecord vehicleCountRecord = new VehicleCountRecord();
            VehicleCountRecord tourCountRecord = new VehicleCountRecord();
            VehicleCountRecord innerCountRecord = new VehicleCountRecord();
            SimpleDateFormat simpleDateFormat1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                startDate = simpleDateFormat1.format(startTime);
                endDate = simpleDateFormat1.format(endTime);
            } catch (Exception e) {
                log.error(e.getMessage(), e);
            }
            //租车应出车数量
            List<OrderPageVO> vehicleDepartureList = orderFeign.getOrderList(nowTime, OrderTypeEnum.RENT_VEHICLE.getCode(), 1).getData();
            if (vehicleDepartureList != null && vehicleDepartureList.size() > 0) {
                vehicleCountRecord.setDepartureNum(vehicleDepartureList.size());
            }
            Map<String, Object> param = new HashMap<>();
            param.put("startTime", DateTime.parse(startDate, DATE_TIME_FORMATTER).toDate());
            param.put("endTime", DateTime.parse(endDate, DATE_TIME_FORMATTER).toDate());
            //1代表出车 2代表还车
            param.put("status", 1);
            param.put("bookUser", -2);
            //1代表正常出车，2代表提前出车，3代表延期出车
            param.put("type", 2);
            //租车提前出车数量
            Integer beforeDepartureNum = vehicleDepartureService.selectAllDepartureLog(param);
            if(beforeDepartureNum != null && beforeDepartureNum > 0) {
                vehicleCountRecord.setBeforeDepartureNum(beforeDepartureNum);
            }
            //租车正常出车数量
            param.put("type", 1);
            Integer normalDepartureNum = vehicleDepartureService.selectAllDepartureLog(param);
            if(normalDepartureNum != null && normalDepartureNum > 0) {
                vehicleCountRecord.setActualDepartureNum(normalDepartureNum);
            }
            //租车延期出车数量
            param.put("type", 3);
            Integer afterDepartureNum = vehicleDepartureService.selectAllDepartureLog(param);
            if(afterDepartureNum != null && afterDepartureNum > 0) {
                vehicleCountRecord.setAfterDepartureNum(afterDepartureNum);
            }
            vehicleCountRecord.setType(VehicleCountType.RENT_VEHICLE.getCode());


            //旅游应出车数量
            List<OrderPageVO> tourDepartureList = orderFeign.getOrderList(nowTime, OrderTypeEnum.TOUR.getCode(), 1).getData();
            if (tourDepartureList != null && tourDepartureList.size() > 0) {
                tourCountRecord.setDepartureNum(tourDepartureList.size());
                tourCountRecord.setActualDepartureNum(tourDepartureList.size());
            }
            tourCountRecord.setType(VehicleCountType.TOUR.getCode());
            //内部用车应出车数量
            List<VehicleBookRecordVo> vehicleDepartureBookRecordList = vehicleBookRecordBiz.selectAllBookRecord(startTime, endTime, 1).getData();
            if (vehicleDepartureBookRecordList != null && vehicleDepartureBookRecordList.size() > 0) {
                innerCountRecord.setDepartureNum(vehicleDepartureBookRecordList.size());
            }
            //1代表出车 2代表还车
            param.put("status", 1);
            param.remove("bookUser");
            //1代表正常出车，2代表提前出车，3代表延期出车
            param.put("type", 2);
            //内部用车提前出车数量
            Integer innerBeforeDepartureNum = vehicleDepartureService.selectAllDepartureLog(param);
            if(innerBeforeDepartureNum != null && innerBeforeDepartureNum > 0) {
                innerCountRecord.setBeforeDepartureNum(innerBeforeDepartureNum);
            }
            param.put("type", 1);
            //内部用车正常出车数量
            Integer innerNormalDepartureNum = vehicleDepartureService.selectAllDepartureLog(param);
            if(innerNormalDepartureNum != null && innerNormalDepartureNum > 0) {
                innerCountRecord.setActualDepartureNum(innerNormalDepartureNum);
            }
            param.put("type", 3);
            //内部用车提前出车数量
            Integer innerAfterDepartureNum = vehicleDepartureService.selectAllDepartureLog(param);
            if(innerAfterDepartureNum != null && innerAfterDepartureNum > 0) {
                innerCountRecord.setAfterDepartureNum(innerAfterDepartureNum);
            }
            innerCountRecord.setType(VehicleCountType.INNER.getCode());




            //租车应还车数量
            List<OrderPageVO> vehicleArrivalList = orderFeign.getOrderList(nowTime, OrderTypeEnum.RENT_VEHICLE.getCode(), 2).getData();
            if (vehicleArrivalList != null && vehicleArrivalList.size() > 0) {
                vehicleCountRecord.setArrivalNum(vehicleArrivalList.size());
            }
            //1代表出车 2代表还车
            param.put("status", 2);
            param.put("bookUser", -2);
            //1代表正常出车，2代表提前出车，3代表延期出车
            param.put("type", 2);
            //租车提前还车数量
            Integer beforeArrivalNum = vehicleDepartureService.selectAllDepartureLog(param);
            if(beforeArrivalNum != null && beforeArrivalNum > 0) {
                vehicleCountRecord.setBeforeArrivalNum(beforeArrivalNum);
            }
            param.put("type", 1);
            //租车正常还车数量
            Integer normalArrivalNum = vehicleDepartureService.selectAllDepartureLog(param);
            if(normalArrivalNum != null && normalArrivalNum > 0) {
                vehicleCountRecord.setActualArrivalNum(normalArrivalNum);
            }
            param.put("type", 3);
            //租车正常还车数量
            Integer afterArrivalNum = vehicleDepartureService.selectAllDepartureLog(param);
            if(afterArrivalNum != null && afterArrivalNum > 0) {
                vehicleCountRecord.setAfterArrivalNum(afterArrivalNum);
            }
            //旅游应还车数量
            List<OrderPageVO> tourArrivalList = orderFeign.getOrderList(nowTime, OrderTypeEnum.TOUR.getCode(), 2).getData();
            if (tourArrivalList != null && tourArrivalList.size() > 0) {
                tourCountRecord.setArrivalNum(tourArrivalList.size());
                tourCountRecord.setActualArrivalNum(tourArrivalList.size());
            }
            //内部用车应还车数量
            List<VehicleBookRecordVo> vehicleArrivalBookRecordList = vehicleBookRecordBiz.selectAllBookRecord(startTime, endTime, 2).getData();
            if (vehicleArrivalBookRecordList != null && vehicleArrivalBookRecordList.size() > 0) {
                innerCountRecord.setArrivalNum(vehicleArrivalBookRecordList.size());
            }
            //1代表出车 2代表还车
            param.put("status", 2);
            param.remove("bookUser");
            //1代表正常出车，2代表提前出车，3代表延期出车
            param.put("type", 2);
            //内部用车提前出车数量
            Integer innerBeforeArrivalNum = vehicleDepartureService.selectAllDepartureLog(param);
            if(innerBeforeArrivalNum != null && innerBeforeArrivalNum > 0) {
                innerCountRecord.setBeforeArrivalNum(innerBeforeArrivalNum);
            }
            param.put("type", 1);
            //内部用车正常出车数量
            Integer innerNormalArrivalNum = vehicleDepartureService.selectAllDepartureLog(param);
            if(innerNormalArrivalNum != null && innerNormalArrivalNum > 0) {
                innerCountRecord.setActualArrivalNum(innerNormalArrivalNum);
            }
            param.put("type", 3);
            //内部用车提前出车数量
            Integer innerAfterArrivalNum = vehicleDepartureService.selectAllDepartureLog(param);
            if(innerAfterArrivalNum != null && innerAfterArrivalNum > 0) {
                innerCountRecord.setAfterArrivalNum(innerAfterArrivalNum);
            }
            //在当前时间内已经取消的记录数
            List<VehicleBookRecordVo> vehicleBookRecordVos = vehicleBookRecordBiz.selectAllCancelBookRecord(param);
            if (vehicleBookRecordVos != null && vehicleBookRecordVos.size() > 0) {
                innerCountRecord.setCancelNum(vehicleBookRecordVos.size());
            }
            //过期未出车无效数据
            param.put("startTime", DateTime.parse("1970-01-01 00:00:00", DATE_TIME_FORMATTER).toDate());
            List<VehicleBookRecordVo> vehicleBookRecordList = vehicleBookRecordBiz.selectAllBookRecord(startTime, endTime, 2).getData();
            if (vehicleBookRecordList != null && vehicleBookRecordList.size() > 0) {
                Iterator<VehicleBookRecordVo> iterator = vehicleBookRecordList.iterator();
                while (iterator.hasNext()) {
                    if(iterator.next().getVehicleDepartureLogVo() != null) {
                        iterator.remove();
                    }
                }
                innerCountRecord.setNoUseNum(vehicleBookRecordList.size());
            }

            innerCountRecord.setType(VehicleCountType.INNER.getCode());
            vehicleCountRecord.setCountDate(nowDate);
            tourCountRecord.setCountDate(nowDate);
            innerCountRecord.setCountDate(nowDate);
            save(vehicleCountRecord);
            save(tourCountRecord);
            save(innerCountRecord);
        }

    }

    /**
     * 添加统计记录
     *
     * @return
     */
    @Scheduled(cron = "0 0 */2 * * *")
    public void add() {
        Long nowTime = getDayStart();
        Long lastTime = nowTime + 24 * 3600 * 1000 - 1;
        Date startTime = new Date();
        startTime.setTime(nowTime);
        Date endTime = new Date();
        endTime.setTime(lastTime);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String startDate = null;
        String endDate = null;
        try {
            startDate = simpleDateFormat.format(startTime);
            endDate = simpleDateFormat.format(endTime);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        DateTime startDay = DateTime.parse(startDate, DEFAULT_DATE_TIME_FORMATTER);
        Date nowDate = startDay.toDate();
        VehicleCountRecord vehicleCountRecord = new VehicleCountRecord();
        VehicleCountRecord tourCountRecord = new VehicleCountRecord();
        VehicleCountRecord innerCountRecord = new VehicleCountRecord();
        //租车应出车数量
        List<OrderPageVO> vehicleDepartureList = orderFeign.getOrderList(nowTime, OrderTypeEnum.RENT_VEHICLE.getCode(), 1).getData();
        if (vehicleDepartureList != null && vehicleDepartureList.size() > 0) {
            vehicleCountRecord.setDepartureNum(vehicleDepartureList.size());
        }
        Map<String, Object> param = new HashMap<>();
        SimpleDateFormat simpleDateFormat1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            startDate = simpleDateFormat1.format(startTime);
            endDate = simpleDateFormat1.format(endTime);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        param.put("startTime", DateTime.parse(startDate, DATE_TIME_FORMATTER).toDate());
        param.put("endTime", DateTime.parse(endDate, DATE_TIME_FORMATTER).toDate());
        //1代表出车 2代表还车
        param.put("status", 1);
        param.put("bookUser", -2);
        //1代表正常出车，2代表提前出车，3代表延期出车
        param.put("type", 2);

        //租车提前出车数量
        Integer beforeDepartureNum = vehicleDepartureService.selectAllDepartureLog(param);
        if(beforeDepartureNum != null && beforeDepartureNum > 0) {
            vehicleCountRecord.setBeforeDepartureNum(beforeDepartureNum);
        }
        //租车正常出车数量
        param.put("type", 1);
        Integer normalDepartureNum = vehicleDepartureService.selectAllDepartureLog(param);
        if(normalDepartureNum != null && normalDepartureNum > 0) {
            vehicleCountRecord.setActualDepartureNum(normalDepartureNum);
        }
        //租车延期出车数量
        param.put("type", 3);
        Integer afterDepartureNum = vehicleDepartureService.selectAllDepartureLog(param);
        if(afterDepartureNum != null && afterDepartureNum > 0) {
            vehicleCountRecord.setAfterDepartureNum(afterDepartureNum);
        }
        vehicleCountRecord.setType(VehicleCountType.RENT_VEHICLE.getCode());


        //旅游应出车数量
        List<OrderPageVO> tourDepartureList = orderFeign.getOrderList(nowTime, OrderTypeEnum.TOUR.getCode(), 1).getData();
        if (tourDepartureList != null && tourDepartureList.size() > 0) {
            tourCountRecord.setDepartureNum(tourDepartureList.size());
            tourCountRecord.setActualDepartureNum(tourDepartureList.size());
        }
        tourCountRecord.setType(VehicleCountType.TOUR.getCode());
        //内部用车应出车数量
        List<VehicleBookRecordVo> vehicleDepartureBookRecordList = vehicleBookRecordBiz.selectAllBookRecord(startTime, endTime, 1).getData();
        if (vehicleDepartureBookRecordList != null && vehicleDepartureBookRecordList.size() > 0) {
            innerCountRecord.setDepartureNum(vehicleDepartureBookRecordList.size());
        }
        //1代表出车 2代表还车
        param.put("status", 1);
        param.remove("bookUser");
        //1代表正常出车，2代表提前出车，3代表延期出车
        param.put("type", 2);
        //内部用车提前出车数量
        Integer innerBeforeDepartureNum = vehicleDepartureService.selectAllDepartureLog(param);
        if(innerBeforeDepartureNum != null && innerBeforeDepartureNum > 0) {
            innerCountRecord.setBeforeDepartureNum(innerBeforeDepartureNum);
        }
        param.put("type", 1);
        //内部用车正常出车数量
        Integer innerNormalDepartureNum = vehicleDepartureService.selectAllDepartureLog(param);
        if(innerNormalDepartureNum != null && innerNormalDepartureNum > 0) {
            innerCountRecord.setActualDepartureNum(innerNormalDepartureNum);
        }
        param.put("type", 3);
        //内部用车提前出车数量
        Integer innerAfterDepartureNum = vehicleDepartureService.selectAllDepartureLog(param);
        if(innerAfterDepartureNum != null && innerAfterDepartureNum > 0) {
            innerCountRecord.setAfterDepartureNum(innerAfterDepartureNum);
        }
        innerCountRecord.setType(VehicleCountType.INNER.getCode());




        //租车应还车数量
        List<OrderPageVO> vehicleArrivalList = orderFeign.getOrderList(nowTime, OrderTypeEnum.RENT_VEHICLE.getCode(), 2).getData();
        if (vehicleArrivalList != null && vehicleArrivalList.size() > 0) {
            vehicleCountRecord.setArrivalNum(vehicleArrivalList.size());
        }
        //1代表出车 2代表还车
        param.put("status", 2);
        param.put("bookUser", -2);
        //1代表正常出车，2代表提前出车，3代表延期出车
        param.put("type", 2);
        //租车提前还车数量
        Integer beforeArrivalNum = vehicleDepartureService.selectAllDepartureLog(param);
        if(beforeArrivalNum != null && beforeArrivalNum > 0) {
            vehicleCountRecord.setBeforeArrivalNum(beforeArrivalNum);
        }
        param.put("type", 1);
        //租车正常还车数量
        Integer normalArrivalNum = vehicleDepartureService.selectAllDepartureLog(param);
        if(normalArrivalNum != null && normalArrivalNum > 0) {
            vehicleCountRecord.setActualArrivalNum(normalArrivalNum);
        }
        param.put("type", 3);
        //租车正常还车数量
        Integer afterArrivalNum = vehicleDepartureService.selectAllDepartureLog(param);
        if(afterArrivalNum != null && afterArrivalNum > 0) {
            vehicleCountRecord.setAfterArrivalNum(afterArrivalNum);
        }
        //旅游应还车数量
        List<OrderPageVO> tourArrivalList = orderFeign.getOrderList(nowTime, OrderTypeEnum.TOUR.getCode(), 2).getData();
        if (tourArrivalList != null && tourArrivalList.size() > 0) {
            tourCountRecord.setArrivalNum(tourArrivalList.size());
            tourCountRecord.setActualArrivalNum(tourArrivalList.size());
        }
        //内部用车应还车数量
        List<VehicleBookRecordVo> vehicleArrivalBookRecordList = vehicleBookRecordBiz.selectAllBookRecord(startTime, endTime, 2).getData();
        if (vehicleArrivalBookRecordList != null && vehicleArrivalBookRecordList.size() > 0) {
            innerCountRecord.setArrivalNum(vehicleArrivalBookRecordList.size());
        }
        //1代表出车 2代表还车
        param.put("status", 2);
        param.remove("bookUser");
        //1代表正常出车，2代表提前出车，3代表延期出车
        param.put("type", 2);
        //内部用车提前出车数量
        Integer innerBeforeArrivalNum = vehicleDepartureService.selectAllDepartureLog(param);
        if(innerBeforeArrivalNum != null && innerBeforeArrivalNum > 0) {
            innerCountRecord.setBeforeArrivalNum(innerBeforeArrivalNum);
        }
        param.put("type", 1);
        //内部用车正常出车数量
        Integer innerNormalArrivalNum = vehicleDepartureService.selectAllDepartureLog(param);
        if(innerNormalArrivalNum != null && innerNormalArrivalNum > 0) {
            innerCountRecord.setActualArrivalNum(innerNormalArrivalNum);
        }
        param.put("type", 3);
        //内部用车提前出车数量
        Integer innerAfterArrivalNum = vehicleDepartureService.selectAllDepartureLog(param);
        if(innerAfterArrivalNum != null && innerAfterArrivalNum > 0) {
            innerCountRecord.setAfterArrivalNum(innerAfterArrivalNum);
        }
        innerCountRecord.setType(VehicleCountType.INNER.getCode());
        //在当前时间内已经取消的记录数
        List<VehicleBookRecordVo> vehicleBookRecordVos = vehicleBookRecordBiz.selectAllCancelBookRecord(param);
        if (vehicleBookRecordVos != null && vehicleBookRecordVos.size() > 0) {
            innerCountRecord.setCancelNum(vehicleBookRecordVos.size());
        }
        //过期未出车无效数据
        param.put("startTime", DateTime.parse("1970-01-01 00:00:00", DATE_TIME_FORMATTER).toDate());
        List<VehicleBookRecordVo> vehicleBookRecordList = vehicleBookRecordBiz.selectAllBookRecord(startTime, endTime, 2).getData();
        if (vehicleBookRecordList != null && vehicleBookRecordList.size() > 0) {
            Iterator<VehicleBookRecordVo> iterator = vehicleBookRecordList.iterator();
            while (iterator.hasNext()) {
                if(iterator.next().getVehicleDepartureLogVo() != null) {
                    iterator.remove();
                }
            }
            innerCountRecord.setNoUseNum(vehicleBookRecordList.size());
        }

        vehicleCountRecord.setCountDate(nowDate);
        tourCountRecord.setCountDate(nowDate);
        innerCountRecord.setCountDate(nowDate);
        save(vehicleCountRecord);
        save(tourCountRecord);
        save(innerCountRecord);
    }

    public void save(VehicleCountRecord vehicleCountRecord) {
        if (vehicleCountRecord != null) {
            Map<String, Object> map = new HashMap<>();
            map.put("type", vehicleCountRecord.getType());
            map.put("startTime", vehicleCountRecord.getCountDate());
            List<VehicleCountRecord> list = mapper.selectByTypeAndTime(map);
            if (list != null && list.size() > 0) {
                BeanUtil.copyProperties(vehicleCountRecord, list.get(0), CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true));
                updateByIdRe(list.get(0));
            } else {
                insertSelective(vehicleCountRecord);
            }
        }
    }

    public ObjectRestResponse export(ExcelParamDto excelParamDto) {
        ExcelExport ee1 = new ExcelExport();
        ee1.addSheetByArray(excelParamDto.getName(), excelParamDto.getData(), excelParamDto.getHeader());
        Properties properties = System.getProperties();
        String osName = properties.getProperty("os.name");
        String path = "";
        if(osName.contains("Windows")) {
            path = "d://"+ excelParamDto.getName() + ".xlsx";
        } else {
            path = "/data/temp/"+ excelParamDto.getName() + ".xlsx";
        }
        File file = new File(path);
        if (!file.exists()) {
            try {
                file.createNewFile();
            } catch (IOException e) {
                log.error(e.getMessage(), e);
                return ObjectRestResponse.createFailedResult(1024, "文件写入失败！");
            }
        }
        OutputStream fis;
        try {
            fis = new FileOutputStream(path);
            ee1.getWorkbook().write(fis);
        } catch (FileNotFoundException e) {
            log.error(e.getMessage(), e);
            return ObjectRestResponse.createFailedResult(1024, "文件不存在！");
        } catch (IOException e) {
            log.error(e.getMessage(), e);
            return ObjectRestResponse.createFailedResult(1024, "文件写入失败！");
        }
        return ObjectRestResponse.succ(path);
    }

    public void download(String path, HttpServletResponse response){
        // 下载本地文件
        String fileName = "export.xlsx".toString(); // 文件的默认保存名
        // 读到流中
        InputStream inStream = null;// 文件的存放路径
        try {
            inStream = new FileInputStream(path);
        } catch (FileNotFoundException e) {
            log.error(e.getMessage(), e);
        }
        // 设置输出的格式
        response.reset();
        response.setContentType("bin");
        response.addHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        // 循环取出流中的数据
        byte[] b = new byte[100];
        int len;
        try {
            while ((len = inStream.read(b)) > 0)
                response.getOutputStream().write(b, 0, len);
            inStream.close();
        } catch (IOException e) {
            log.error(e.getMessage(), e);
        }
    }


    public Map<Integer, Integer> getDeparture(List<VehicleBookRecordVo> list, Integer type) {
        Map<Integer, Integer> map = new HashMap<>();
        Integer a = 0;
        Integer b = 0;
        Integer c = 0;
        for (VehicleBookRecordVo vehicleBookRecordVo : list) {
            //延后交车
            if (type == 1) {
                if (vehicleBookRecordVo.getVehicleDepartureLogVo() == null) {
                    a++;
                    //提前交车
                } else if (vehicleBookRecordVo.getVehicleDepartureLogVo() != null && DateTime.parse(vehicleBookRecordVo.getVehicleDepartureLogVo().getDepartureTime(), DATE_TIME_FORMATTER).getMillis() < getDayStart(vehicleBookRecordVo.getBookStartDate().getTime())) {
                    b++;
                    //正常交车
                } else if (vehicleBookRecordVo.getVehicleDepartureLogVo() != null && DateTime.parse(vehicleBookRecordVo.getVehicleDepartureLogVo().getDepartureTime(), DATE_TIME_FORMATTER).getMillis() >= getDayStart(vehicleBookRecordVo.getBookStartDate().getTime()) && DateTime.parse(vehicleBookRecordVo.getVehicleDepartureLogVo().getDepartureTime(), DATE_TIME_FORMATTER).getMillis() <= getDayStart(vehicleBookRecordVo.getBookStartDate().getTime()) + 24 * 3600 * 1000 - 1) {
                    c++;
                }
            } else if (type == 2) {
                //延后还车
                if (vehicleBookRecordVo.getVehicleDepartureLogVo() != null && vehicleBookRecordVo.getVehicleDepartureLogVo().getState() == 1 && DateTime.parse(vehicleBookRecordVo.getVehicleDepartureLogVo().getArrivalTime(), DATE_TIME_FORMATTER).getMillis() > getDayStart(vehicleBookRecordVo.getBookEndDate().getTime()) + 24 * 3600 * 1000 - 1) {
                    a++;
                    //提前还车
                } else if (vehicleBookRecordVo.getVehicleDepartureLogVo() != null && vehicleBookRecordVo.getVehicleDepartureLogVo().getState() == 1 && DateTime.parse(vehicleBookRecordVo.getVehicleDepartureLogVo().getArrivalTime(), DATE_TIME_FORMATTER).getMillis() < getDayStart(vehicleBookRecordVo.getBookEndDate().getTime())) {
                    b++;
                    //正常还车
                } else if (vehicleBookRecordVo.getVehicleDepartureLogVo() != null && vehicleBookRecordVo.getVehicleDepartureLogVo().getState() == 1 && DateTime.parse(vehicleBookRecordVo.getVehicleDepartureLogVo().getArrivalTime(), DATE_TIME_FORMATTER).getMillis() >= getDayStart(vehicleBookRecordVo.getBookEndDate().getTime()) && DateTime.parse(vehicleBookRecordVo.getVehicleDepartureLogVo().getArrivalTime(), DATE_TIME_FORMATTER).getMillis() <= getDayStart(vehicleBookRecordVo.getBookEndDate().getTime()) + 24 * 3600 * 1000 - 1) {
                    c++;
                }
            }

        }
        map.put(1, a);
        map.put(2, b);
        map.put(3, c);
        return map;
    }

    public static Long getDayStart() {
        long current = System.currentTimeMillis();
        long zero = current / (1000 * 3600 * 24) * (1000 * 3600 * 24) - TimeZone.getDefault().getRawOffset();
        return zero;
    }

    public static Long getDayStart(Long time) {
        long current = time;
        long zero = current / (1000 * 3600 * 24) * (1000 * 3600 * 24) - TimeZone.getDefault().getRawOffset();
        return zero;
    }
}
