package com.xxfc.platform.vehicle.entity;

import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

@Table(name = "campsite")
@Data
public class Campsite {
    @Id
//    @GeneratedValue(generator = "JDBC")
    private Integer id;

    /**
     * 分公司名称
     */
    private String name;

    /**
     * 分支机构类型
     */
    @Column(name = "branch_type")
    private Integer branchType;

    /**
     * 分支机构所属机构
     */
    @Column(name = "subordinate_branch")
    private Integer subordinateBranch;


    /**
     * 地址-省/直辖市(编码)
     */
    @Column(name = "addr_province")
    private Integer addrProvince;

    /**
     * 地址-市(编码)
     */
    @Column(name = "addr_city")
    private Integer addrCity;

    /**
     * 地址-镇/县（编码）
     */
    @Column(name = "addr_town")
    private Integer addrTown;

    /**
     * 详细地址
     */
    @Column(name = "addr_detail")
    private String addrDetail;

    private Date createTime;

    private Date updateTime;

    /**
     * 负责人
     */
    private String leader;

    /**
     * 负责人联系方式
     */
    private String leaderContactInfo;
    /**
     * 分公司状态
     */
    private Integer status;

    /**
     *公司地址-纬度
     */
    private BigDecimal latitude;

    /**
     * 公司地址-经度
     */
    private BigDecimal longitude;

    private String companyPic;

    private Integer zoneId;
}