package com.xxfc.platform.order.pojo.vo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/12/25 10:17
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class OrderReceivedStatisticsBaseVo {
    /**
     * 年月日
     */
    private Date date;
    /**
     * 订单总额
     */
    private BigDecimal totalAmount;
    /**
     *租车订单总额
     */
    private BigDecimal rentVehicleAmount;
    /**
     * 订单总量(包含押金，不计免赔)
     */
    private Integer totalQuantity;
    /**
     * 租车订单量
     */
    private Integer rentVehicleQuantity;
    /**
     * 支付方式 '1:微信公众号支付 2.支付宝即时到账,3,银联'
     */
    private Integer payWay;
    /***
     * 分公司id
     */
    private Integer companyId;
    /**
     * 分公司名称
     */
    private String companyName;
}
