package com.xxfc.platform.order.pojo.order;

import com.github.wxiaoqi.security.common.vo.PageParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 订单查询类
 */
@Data
public class QueryOrderDTO extends PageParam {
    @ApiModelProperty(hidden = false)
    private Integer crtUser;

    @ApiModelProperty(hidden = false)
    private Integer userId;

    @ApiModelProperty(hidden = false)
    private Integer crtCompanyId;

    @ApiModelProperty(value = "订单状态\n" +
            "0--删除\n" +
            "1--创建订单\n" +
            "2--取消\n" +
            "3--待付款\n" +
            "4--待出行\n" +
            "5--出行中（进行中）\n" +
            "6--已完成"+
            "7--定損中")
    private Integer status;

    private String multiStatus;

    @ApiModelProperty(value = "是否有使用会员权益")
    private Integer hasMemberRight;

    @ApiModelProperty(value = "订单类型 1--租车；2--旅游; 3--会员订单")
    private Integer type;

    private String multiTypes;

    /**
     * 开票状态，0未开票，1已开票
     */
    private Integer invoiceStatus;
}