package com.xxfc.platform.order.pojo;

import com.alibaba.fastjson.JSON;
import com.xxfc.platform.order.pojo.account.OrderAccountDetail;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.util.StringUtils;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@Data
public class ReturnOrderAmount implements Serializable {
    private static final long serialVersionUID = -8445943548965154778L;

    private static final Map<Integer, String> orderTypeMap = new HashMap<>();

    static {
        orderTypeMap.put(1, "租车");
        orderTypeMap.put(2, "旅游");
        orderTypeMap.put(3, "会员");
    }

    @ApiModelProperty(value = "时间")
    private Long time;
    @ApiModelProperty(value = "订单号")
    private String no;
    @ApiModelProperty(value = "订单类型")
    private Integer type;
    @ApiModelProperty(value = "订单明细")
    private String accountDetail;
    @ApiModelProperty(value = "用户姓名")
    private String realname;
    @ApiModelProperty(value = "手机号")
    private String username;
    @ApiModelProperty(value = "退款说明")
    private String refundInstruction;
    @ApiModelProperty(value = "退款明细")
    private BigDecimal refundAmount = BigDecimal.ZERO;
    @ApiModelProperty("退还类型")
    @Column(name = "account_type")
    private Integer accountType;

    public OrderAccountDetail getAccountDetail() {
        return StringUtils.hasText(accountDetail) ? JSON.parseObject(accountDetail, OrderAccountDetail.class) : new OrderAccountDetail();
    }

    public String getType() {
        return orderTypeMap.get(type);
    }
    public Integer getTypeInt() {
     return this.type;
    }

    public String getTime() {
        Date date = new Date(this.time);
       return  new SimpleDateFormat("yyyy-MM-dd").format(date);

    }
}
