package com.xxfc.platform.activity.biz;

import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.xxfc.platform.activity.entity.ActivityPopularizeItem;
import com.xxfc.platform.activity.mapper.ActivityPopularizeItemMapper;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

import java.util.List;

/**
 * 推广活动项，一个活动对应多个项
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-07-05 15:23:04
 */
@Service
public class ActivityPopularizeItemBiz extends BaseBiz<ActivityPopularizeItemMapper,ActivityPopularizeItem> {

	public List<ActivityPopularizeItem> selectByPopularizeId(Integer popularizeId) {
		Example example = new Example(ActivityPopularizeItem.class);
		example.createCriteria().andEqualTo("popularizeId", popularizeId);
		example.orderBy("sort").asc();
		return  mapper.selectByExample(example);
	}

}