package com.github.wxiaoqi.security.admin.rest.admin;

import com.github.wxiaoqi.security.admin.biz.AppShareholderDetailBiz;
import com.github.wxiaoqi.security.admin.biz.AppShareholderDetailChangeRecordBiz;
import com.github.wxiaoqi.security.admin.dto.AppShareholderDetailDTO;
import com.github.wxiaoqi.security.admin.dto.AppShareholderDetailFindDTO;
import com.github.wxiaoqi.security.admin.entity.AppShareholderDetail;
import com.github.wxiaoqi.security.admin.vo.AppShareholderDetailVo;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.github.wxiaoqi.security.auth.client.jwt.UserAuthUtil;
import com.github.wxiaoqi.security.auth.common.util.jwt.IJWTInfo;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.vehicle.util.excel.ExcelImport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

@Slf4j
@RestController
@RequestMapping("/appShareholder")
@Api("后台*会员管理")
public class AppShareholderDetailController {
    @Autowired
    private UserAuthUtil userAuthUtil;

    @Autowired
    private UserAuthConfig userAuthConfig;

    @Autowired
    private AppShareholderDetailBiz appShareholderDetailBiz;

    @Autowired
    private AppShareholderDetailChangeRecordBiz appShareholderDetailChangeRecordBiz;

    @ApiOperation("批量导入股东")
    @PostMapping("/export")
    public ObjectRestResponse importAppShareholder(@RequestPart("file") MultipartFile appShareholderExcel, HttpServletRequest request) {
        try {
            IJWTInfo infoFromToken = userAuthUtil.getInfoFromToken(userAuthConfig.getToken(request));
            Integer operatorId = Integer.valueOf(infoFromToken.getId());
            List<String[]> appShareholderData = ExcelImport.getExcelData(appShareholderExcel);
            if (appShareholderData.size() < 1) {
                return ObjectRestResponse.createFailedResult(1001, "导入不能没数据！！！");
            }
//            appShareholderData.remove(0);
            return ObjectRestResponse.succ(appShareholderDetailBiz.importShareholder(appShareholderData, operatorId))
                    ;
        } catch (Exception e) {
            throw new BaseException(e);
        }
    }

    /**
     * @param appShareholderDetailFindDTO
     * @return
     */
    @PostMapping("/page")
    public ObjectRestResponse<PageDataVO<AppShareholderDetailVo>> findWithPage(@RequestBody AppShareholderDetailFindDTO appShareholderDetailFindDTO) {
        PageDataVO<AppShareholderDetailVo> dataVO = appShareholderDetailBiz.findWithPage(appShareholderDetailFindDTO);
        return ObjectRestResponse.succ(dataVO);
    }


    /**
     * 新增股东信息
     *
     * @return
     */
    @PostMapping("/addUserPostion")
    public ObjectRestResponse<Void> addUserPostion(@RequestBody AppShareholderDetailDTO appShareholderDetailDTO, HttpServletRequest request) {
        try {
            IJWTInfo infoFromToken = userAuthUtil.getInfoFromToken(userAuthConfig.getToken(request));
            Integer operatorId = Integer.valueOf(infoFromToken.getId());
            return appShareholderDetailBiz.add(appShareholderDetailDTO, operatorId);
        } catch (Exception e) {
            log.error("新增失败【{}】", e);
            throw new BaseException("新增失败");
        }
    }

    /**
     * 股东身份信息变更
     *
     * @return
     */
    @PostMapping("/updUserPostion")
    public ObjectRestResponse<Void> updUserPostion(@RequestBody AppShareholderDetailDTO appShareholderDetailDTO, HttpServletRequest request) {
        try {
            IJWTInfo infoFromToken = userAuthUtil.getInfoFromToken(userAuthConfig.getToken(request));
            Integer operatorId = Integer.valueOf(infoFromToken.getId());
            return appShareholderDetailBiz.updSharehoder(appShareholderDetailDTO, operatorId);
        } catch (Exception e) {
            log.error("修改失败【{}】", e);
            throw new BaseException("修改失败");
        }
    }

    /**
     * 查询股東信息变更记录表
     */
    @GetMapping("/findShareholderChangeRecord")
    public ObjectRestResponse findShareholderChangeRecord(AppShareholderDetail appShareholderDetail) {
        return ObjectRestResponse.succ(appShareholderDetailChangeRecordBiz.findShareholderChangeRecord(appShareholderDetail));
    }



}
