package com.github.wxiaoqi.security.admin.biz;


import com.github.wxiaoqi.security.admin.dto.AppUserPositionChangeRecordDTO;
import com.github.wxiaoqi.security.admin.dto.AppUserPositionTempDTO;
import com.github.wxiaoqi.security.admin.entity.AppUserPositionChangeRecord;
import com.github.wxiaoqi.security.admin.entity.AppUserPositionTemp;
import com.github.wxiaoqi.security.admin.mapper.AppUserPositionChangeRecordMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

@Transactional
@Service("appUserPositionChangeRecordBiz")
public class AppUserPositionChangeRecordBiz extends BaseBiz<AppUserPositionChangeRecordMapper, AppUserPositionChangeRecord> {


    @Autowired
    private AppUserPositionBiz appUserPositionBiz;

    @Autowired
    private AppUserJobLevelBiz appUserJobLevelBiz;

    public static final int USER_ADD_COMPANY = 1;
    public static final int JOB_CHANGE = 2;
    public static final int POSITION_CHANGE = 3;
    public static final int COMPANY_CHANGE = 4;
    public static final int USER_LEAVE_COMPANT = 5;
    public static final int USER_AND_ADD_COMPANY = 6;

    /**
     * 变更记录表插入
     *
     * @param userPositionTemp
     */
    public void addPositionChangeRecord(AppUserPositionTemp userPositionTemp, AppUserPositionTemp oldData, Integer operatorId, Timestamp relTime) {
        AppUserPositionChangeRecord appUserPositionChangeRecord = new AppUserPositionChangeRecord();

        if (!(userPositionTemp.getIsQuit().equals(oldData.getIsQuit()))) {
            appUserPositionChangeRecord.setJobRemark(USER_LEAVE_COMPANT);
        }

        //状态1：职位变动
        if (!(userPositionTemp.getJobId().equals(oldData.getJobId()))) {
            appUserPositionChangeRecord.setOldJobId(oldData.getJobId());
            appUserPositionChangeRecord.setNewJobId(userPositionTemp.getJobId());
            appUserPositionChangeRecord.setJobRemark(JOB_CHANGE);
            findUserJobName(appUserPositionChangeRecord);
        }
        //状态2：身份变动
        if (!(userPositionTemp.getPositionId().equals(oldData.getPositionId()))) {
            appUserPositionChangeRecord.setOldPositionId(oldData.getPositionId());
            appUserPositionChangeRecord.setNewPositionId(userPositionTemp.getPositionId());
            appUserPositionChangeRecord.setJobRemark(POSITION_CHANGE);
            findUserPositionName(appUserPositionChangeRecord);
        }
        //状态3：公司变动调整
        if (!(userPositionTemp.getCompanyId().equals(oldData.getCompanyId()))) {
            appUserPositionChangeRecord.setOldCompanyId(oldData.getCompanyId());
            appUserPositionChangeRecord.setOldCompanyName(oldData.getCompanyName());
            appUserPositionChangeRecord.setNewCompanyId(userPositionTemp.getCompanyId());
            appUserPositionChangeRecord.setNewCompanyName(userPositionTemp.getCompanyName());
            appUserPositionChangeRecord.setJobRemark(COMPANY_CHANGE);
        }

        appUserPositionChangeRecord.setUserId(userPositionTemp.getId());
        appUserPositionChangeRecord.setPhone(userPositionTemp.getPhone());
        appUserPositionChangeRecord.setRelTime(relTime);
        appUserPositionChangeRecord.setUserName(userPositionTemp.getName());
        appUserPositionChangeRecord.setCrtTime(new Timestamp(System.currentTimeMillis()));
        appUserPositionChangeRecord.setOperatorId(operatorId);
        mapper.insert(appUserPositionChangeRecord);
    }

    /**
     * 入职时插入记录表
     *
     * @param userPositionTemp
     * @param updUserId
     */
    public void addJoinJobRecord(AppUserPositionTempDTO userPositionTemp, Integer updUserId) {
        AppUserPositionChangeRecord appUserPositionChangeRecord = new AppUserPositionChangeRecord();
        appUserPositionChangeRecord.setPhone(userPositionTemp.getPhone());
        appUserPositionChangeRecord.setUserName(userPositionTemp.getName());
        appUserPositionChangeRecord.setRelTime(userPositionTemp.getRelTime());
        appUserPositionChangeRecord.setCrtTime(new Timestamp(System.currentTimeMillis()));
        appUserPositionChangeRecord.setJobRemark(USER_ADD_COMPANY);
        appUserPositionChangeRecord.setOperatorId(updUserId);
        appUserPositionChangeRecord.setUserId(userPositionTemp.getId());
        mapper.insert(appUserPositionChangeRecord);
    }


    /**
     * 批量插入记录表
     *
     * @param userPositionTemp
     * @param updUserId
     */
    public void addJoinJobRecord(AppUserPositionTemp userPositionTemp, Integer updUserId) {
        AppUserPositionChangeRecord appUserPositionChangeRecord = new AppUserPositionChangeRecord();
        appUserPositionChangeRecord.setPhone(userPositionTemp.getPhone());
        appUserPositionChangeRecord.setUserName(userPositionTemp.getName());
        appUserPositionChangeRecord.setCrtTime(new Timestamp(System.currentTimeMillis()));
        appUserPositionChangeRecord.setRelTime(new Timestamp(System.currentTimeMillis()));
        appUserPositionChangeRecord.setJobRemark(USER_ADD_COMPANY);
        appUserPositionChangeRecord.setOperatorId(updUserId);
        appUserPositionChangeRecord.setUserId(userPositionTemp.getId());
        mapper.insert(appUserPositionChangeRecord);
    }


    /**
     * 员工复职
     *
     * @param userPositionTemp
     * @param updUserId
     */
    public void andAddJoinJobRecord(AppUserPositionTempDTO userPositionTemp, Integer updUserId) {
        AppUserPositionChangeRecord appUserPositionChangeRecord = new AppUserPositionChangeRecord();
        appUserPositionChangeRecord.setPhone(userPositionTemp.getPhone());
        if (userPositionTemp.getPositionId() != null) {
            appUserPositionChangeRecord.setNewPositionId(userPositionTemp.getPositionId());
        }
        appUserPositionChangeRecord.setUserName(userPositionTemp.getName());
        appUserPositionChangeRecord.setRelTime(userPositionTemp.getRelTime());
        appUserPositionChangeRecord.setCrtTime(new Timestamp(System.currentTimeMillis()));
        appUserPositionChangeRecord.setJobRemark(USER_AND_ADD_COMPANY);
        appUserPositionChangeRecord.setOperatorId(updUserId);
        appUserPositionChangeRecord.setUserId(userPositionTemp.getId());
        mapper.insert(appUserPositionChangeRecord);
    }

    /**
     * APP用户修改身份
     *
     * @param userPositionTemp
     * @param updUserId
     */
    public void andAddJoinJobRecord(AppUserPositionTemp userPositionTemp, Integer updUserId) {
        AppUserPositionChangeRecord appUserPositionChangeRecord = new AppUserPositionChangeRecord();
        appUserPositionChangeRecord.setPhone(userPositionTemp.getPhone());
        if (userPositionTemp.getPositionId() != null) {
            appUserPositionChangeRecord.setNewPositionId(userPositionTemp.getPositionId());
        }
        appUserPositionChangeRecord.setUserName(userPositionTemp.getName());
        appUserPositionChangeRecord.setCrtTime(new Timestamp(System.currentTimeMillis()));
        appUserPositionChangeRecord.setJobRemark(USER_AND_ADD_COMPANY);
        appUserPositionChangeRecord.setOperatorId(updUserId);
        mapper.insert(appUserPositionChangeRecord);
    }


    /**
     * 查询新旧职位名称
     * zyh
     *
     * @param appUserPositionChangeRecord
     * @return
     */

    public AppUserPositionChangeRecord findUserJobName(AppUserPositionChangeRecord appUserPositionChangeRecord) {
        appUserPositionChangeRecord.setNewJobName(appUserJobLevelBiz.selectById(appUserPositionChangeRecord.getNewJobId()).getName());
        appUserPositionChangeRecord.setOldJobName(appUserJobLevelBiz.selectById(appUserPositionChangeRecord.getOldJobId()).getName());
        return appUserPositionChangeRecord;
    }

    /**
     * 查询新旧身份名称
     * zyh
     *
     * @param appUserPositionChangeRecord
     * @return
     */
    public AppUserPositionChangeRecord findUserPositionName(AppUserPositionChangeRecord appUserPositionChangeRecord) {
        appUserPositionChangeRecord.setOldPositionName(appUserPositionBiz.selectById(appUserPositionChangeRecord.getOldPositionId()).getName());
        appUserPositionChangeRecord.setNewPositionName(appUserPositionBiz.selectById(appUserPositionChangeRecord.getNewPositionId()).getName());
        return appUserPositionChangeRecord;
    }


    /**
     * 查询员工信息变更记录表
     */
    public List<AppUserPositionChangeRecordDTO> findPositionChangeRecord(AppUserPositionTemp userPositionTemp) {
        Example example = new Example(AppUserPositionChangeRecord.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("userId", userPositionTemp.getId());
        if (userPositionTemp.getId() != null) {
            criteria.andEqualTo("phone", userPositionTemp.getPhone());
        }
        List<AppUserPositionChangeRecord> list = selectByExample(example);
        List<AppUserPositionChangeRecordDTO> listAppUserPositionChangeRecordDTO = new ArrayList<>();
        list.stream().forEach(x -> {
            AppUserPositionChangeRecordDTO appUserPositionChangeRecordDTO = new AppUserPositionChangeRecordDTO();
            BeanUtils.copyProperties(x, appUserPositionChangeRecordDTO);
            listAppUserPositionChangeRecordDTO.add(appUserPositionChangeRecordDTO);
        });
        return listAppUserPositionChangeRecordDTO;
    }
}
