/*
 * Decompiled with CFR 0.152.
 */
package ytx.org.apache.http.impl.auth;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import ytx.org.apache.http.HeaderElement;
import ytx.org.apache.http.annotation.NotThreadSafe;
import ytx.org.apache.http.auth.ChallengeState;
import ytx.org.apache.http.auth.MalformedChallengeException;
import ytx.org.apache.http.impl.auth.AuthSchemeBase;
import ytx.org.apache.http.message.BasicHeaderValueParser;
import ytx.org.apache.http.message.ParserCursor;
import ytx.org.apache.http.util.CharArrayBuffer;

@NotThreadSafe
public abstract class RFC2617Scheme
extends AuthSchemeBase {
    private final Map<String, String> params = new HashMap<String, String>();

    public RFC2617Scheme(ChallengeState challengeState) {
        super(challengeState);
    }

    public RFC2617Scheme() {
        this(null);
    }

    @Override
    protected void parseChallenge(CharArrayBuffer buffer, int pos, int len) throws MalformedChallengeException {
        BasicHeaderValueParser parser = BasicHeaderValueParser.DEFAULT;
        ParserCursor cursor = new ParserCursor(pos, buffer.length());
        HeaderElement[] elements = parser.parseElements(buffer, cursor);
        if (elements.length == 0) {
            throw new MalformedChallengeException("Authentication challenge is empty");
        }
        this.params.clear();
        HeaderElement[] headerElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            HeaderElement element = headerElementArray[n2];
            this.params.put(element.getName(), element.getValue());
            ++n2;
        }
    }

    protected Map<String, String> getParameters() {
        return this.params;
    }

    @Override
    public String getParameter(String name) {
        if (name == null) {
            return null;
        }
        return this.params.get(name.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public String getRealm() {
        return this.getParameter("realm");
    }
}

