package com.xxfc.platform.tour.rest;

import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.common.annotation.BeanValid;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.tour.biz.TourUserScoreBiz;
import com.xxfc.platform.tour.dto.TourUserScoreDTO;
import com.xxfc.platform.tour.entity.TourUserScore;
import com.xxfc.platform.tour.vo.TourUserScoreVo;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("tourUserScore")
public class TourUserScoreController extends BaseController<TourUserScoreBiz,TourUserScore> {
    /**
     * 保存评论
     * @param tourUserScoreDTO
     * @param appUserDTO
     * @return
     */
    @PostMapping("/score")
    public ObjectRestResponse<Void> saveTourUserScore(@RequestBody @BeanValid TourUserScoreDTO tourUserScoreDTO, AppUserDTO appUserDTO){
        int effectRows = getBaseBiz().saveTourUserScore(tourUserScoreDTO,appUserDTO);
        if (effectRows>0){
            return ObjectRestResponse.succ();
        }
        return ObjectRestResponse.createDefaultFail();
    }
    /**
     * 根据车型查询评论列表  根据评分时间排序
     *
     * @param modelId
     * @param pageNo
     * @param pageSize
     * @return
     */
    @GetMapping("/app/unauth/scores")
    public ObjectRestResponse<PageDataVO<TourUserScoreVo>> findVehicleUserScorePageByModelId(@RequestParam("modelId") Integer modelId,
                                                                                             @RequestParam(value = "pageNo",required = false,defaultValue = "1")Integer pageNo,
                                                                                             @RequestParam(value = "pageSize",required = false,defaultValue = "10") Integer pageSize) {
        PageDataVO<TourUserScoreVo> pageDataVO = getBaseBiz().findTourUserScorePageByGoodId(modelId,pageNo,pageSize);
        return ObjectRestResponse.succ(pageDataVO);
    }

    /**
     * 根据订单id查询评价详情
     * @param orderId
     * @return
     */
    @GetMapping("/score/order/{orderId}")
    public ObjectRestResponse findVehicleUserScoreDetailByOrderId(@PathVariable("orderId") Integer orderId){
        TourUserScoreVo vehicleUserScoreVo = getBaseBiz().findTourUserScoreDetailByOrderId(orderId);
        return ObjectRestResponse.succ(vehicleUserScoreVo);
    }
}