package com.xxfc.platform.tour.biz;

import cn.hutool.core.date.DateUtil;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.tour.vo.TourGoodOrderFindVo;
import com.xxfc.platform.tour.vo.TourGoodOrderVo;
import org.springframework.stereotype.Service;
import  com.xxfc.platform.tour.entity.TourGoodVerification;
import  com.xxfc.platform.tour.mapper.TourGoodVerificationMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalTime;
import java.util.*;

/**
 * 旅游线路核销明细
 *
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-14 09:36:50
 */
@Service
public class TourGoodVerificationBiz extends BaseBiz<TourGoodVerificationMapper,TourGoodVerification> {

    //删除线路核销
    public  void delGoodVerification(Integer goodId,List<Integer> ids){ mapper.delVerification(goodId,ids);}

    /**
     * 批量插入核销
     * @param tourGoodVerifications
     */
    public  void addBathTourGoodVerification(List<TourGoodVerification> tourGoodVerifications){
        for (TourGoodVerification tourGoodVerification:tourGoodVerifications){
            mapper.insertTourGoodVerification(tourGoodVerification);
        }
    }

    /**
     * 分页查询订单列表
     * @param tourGoodOrderFindVo
     * @return
     */
    public PageDataVO<TourGoodOrderVo> findTourGoodOrdersPage(TourGoodOrderFindVo tourGoodOrderFindVo) {

         Date trvaelTime = tourGoodOrderFindVo.getTravelTime();
        String dateStr = DateUtil.format(trvaelTime, "YYYY-MM-dd");
        tourGoodOrderFindVo.setTravelDate(dateStr);
        PageDataVO<TourGoodOrderVo>  tourGoodOrderVoPageDataVO= PageDataVO.pageInfo(tourGoodOrderFindVo.getPage(), tourGoodOrderFindVo.getLimit(), () -> mapper.findVerificationAll(tourGoodOrderFindVo));
        List<TourGoodOrderVo> tourGoodOrderVos = tourGoodOrderVoPageDataVO.getData();
         tourGoodOrderVos.stream().peek(tourGoodOrderVo -> {
            tourGoodOrderVo.setLeaveOfNum(tourGoodOrderVo.getHeadCount()-tourGoodOrderVo.getTripOfNum());
            String startDateStr = DateUtil.format(tourGoodOrderVo.getStartDate(),"YYYY-MM-dd");
             tourGoodOrderVo.setTravelTime(startDateStr);

             Long startTime = tourGoodOrderVo.getStartTime();
             if (null!=startTime){
               /*  LocalTime localTime = LocalTime.ofSecondOfDay(startTime);
                 String timeStr = String.format("%s:%s:%s",localTime.getHour()==0?"00":localTime.getHour(),
                         localTime.getMinute()==0?"00":localTime.getMinute(),localTime.getSecond()==0?"00":localTime.getSecond());*/
                 String timeStr=new SimpleDateFormat("HH:mm").format(startTime);
                 tourGoodOrderVo.setTravelTime(String.format("%s %s",tourGoodOrderVo.getTravelTime(),timeStr));
             }
        }).count();
        return tourGoodOrderVoPageDataVO;
    }

    /**
     * 更改发车状态
      * @param verficationId
     * @return
     */
    public int updateTourGoodVerificationStatus(Integer verficationId){
        return mapper.updateStatusByGoodIdAndSpeIdAndSiteId(verficationId,0);
    }

    /**
     * 更新总人数 或 上车人数
      * @param verficationId
     * @param properties
     * @return
     */
    public int updateTourGoodPersonNum(Integer verficationId,String properties,Integer number){

         return mapper.updateTourGoodPerNumbs(verficationId,properties,number);
    }
}