package com.xxfc.platform.im.biz;




import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.wxiaoqi.security.common.constant.RestCode;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.xxfc.platform.im.model.Comment;
import com.xxfc.platform.im.model.Msg;
import com.xxfc.platform.im.model.Praise;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component
public class MsgBiz {

    @Autowired
    private MongoTemplate mongoTemplate;


    /**
     * 获取消息列表
     * @param map
     * @return
     * @throws Exception
     */
    public ObjectRestResponse getMsgList(Map<String, Object> map)  throws Exception{
       //获取所有朋友圈
        String userId = map.get("userId").toString();
        PageHelper.startPage(Integer.parseInt(map.get("page").toString()),Integer.parseInt(map.get("limit").toString()));
        List<Msg>msgList = fetchAndAttach(mongoTemplate.findAll(Msg.class, "s_msg"),userId);
        PageInfo<Msg> goodPageInfo = new PageInfo<>(msgList);
        return  new ObjectRestResponse().status(RestCode.SUCCESS.getStatus()).msg(RestCode.SUCCESS.getMsg()).data(goodPageInfo);
    }

    /**
     * 添加评论和点赞
     * @param list
     * @param userId
     * @return
     */
    private List<Msg> fetchAndAttach(List<Msg>list ,String userId) {
        for (Msg msg:list) {
            //添加评论
            Query query = new Query(Criteria.where("msgId").is(msg.getMsgId()));
            List <Comment>comments =  mongoTemplate.find(query,Comment.class,"s_comment");
            msg.setComments(comments);

            //添加点赞
            List <Praise>praise =  mongoTemplate.find(query,Praise.class,"s_praise");
            msg.setPraises(praise);

            msg.setIsPraise(this.exists(Integer.parseInt(userId),msg.getMsgId()) ? 1 : 0);
            msg.setIsCollect(this.existsCollect(Integer.parseInt(userId),msg.getMsgId())? 1 : 0);
        }
        return list;
    }

    /**
     * 判断是否点赞
     * @param userId
     * @param msgId
     * @return
     */
    public boolean exists(int userId, ObjectId msgId) {
        Query query = new Query(Criteria.where("msgId").is(msgId).and("userId").is(userId));
        List <Praise>praise =  mongoTemplate.find(query,Praise.class,"s_praise");
        return 0 != praise.size();
    }

    /**
     * 判断是否评论
     * @param userId
     * @param msgId
     * @return
     */
    public boolean existsCollect(int userId, ObjectId msgId) {
        Query query = new Query(Criteria.where("msgId").is(msgId).and("userId").is(userId));
        List <Comment>comments =  mongoTemplate.find(query,Comment.class,"s_comment");
        return 0 != comments.size();
    }
}
