package com.xxfc.platform.im.biz;

import com.xxfc.platform.im.mapper.ImQuestionMapper;
import com.xxfc.platform.im.model.Msg;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

import com.xxfc.platform.im.entity.ImQuestion;
import com.github.wxiaoqi.security.common.biz.BaseBiz;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-06-24 10:45:05
 */
@Service
public class ImQuestionBiz extends BaseBiz<ImQuestionMapper,ImQuestion> {
    @Autowired
    private ImQuestionMapper imQuestionMapper;

    @Autowired
    private MongoTemplate mongoTemplate;

    public Object getQuestionList(Map<String,Object> map){
        Map<String,Object>returnMap = new HashMap<>();
        List<Msg>list = mongoTemplate.findAll(Msg.class, "s_msg");
        returnMap.put("msg",list);
        returnMap.put("question",imQuestionMapper.getQuestionList(map));
        return returnMap;
    }

}