package com.xxfc.platform.app.entity;

import java.io.Serializable;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 
 * 
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-06-24 10:34:00
 */
@Data
@Table(name = "app_version")
public class AppVersion implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  app版本信息表
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("app版本信息表")
    private Integer id;
	
	    /**
     *  app手机系统类型（0：安卓，1：IOS）
     */
    @Column(name = "sys_type")
	@ApiModelProperty(value = "app手机系统类型（0：安卓，1：IOS）")
    private Integer sysType;
	
    /**
     *  版本号
     */
    @Column(name = "version")
	@ApiModelProperty(value = "版本号")
    private String version;

	/**
	 *  版本号
	 */
	@Column(name = "version_name")
	@ApiModelProperty(value = "版本号名称")
	private String versionName;
	
	    /**
     *  包的大小
     */
    @Column(name = "packagesize")
	@ApiModelProperty(value = "包的大小")
    private String packagesize;
	
	    /**
     *  升级内容
     */
    @Column(name = "content")
	@ApiModelProperty(value = "升级内容")
    private String content;
	
	    /**
     *  下载地址
     */
    @Column(name = "download_url")
	@ApiModelProperty(value = "下载地址")
    private String downloadUrl;
	
	    /**
     *  下载开关（0：可下载，1：不可下载）
     */
    @Column(name = "download_switch")
	@ApiModelProperty(value = "下载开关（0：可下载，1：不可下载）")
    private Integer downloadSwitch;
	
	    /**
     *  权重
     */
    @Column(name = "weigh")
	@ApiModelProperty(value = "权重")
    private Integer weigh;
	
	    /**
     *  版本上传时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "版本上传时间", hidden = true )
    private Long crtTime;
	
	    /**
     *  是否删除；0-正常；1-删除
     */
    @Column(name = "is_del")
	@ApiModelProperty(value = "是否删除；0-正常；1-删除")
    private Integer isDel;
	

}
