package com.xxfc.platform.activity;

import com.ace.cache.EnableAceCache;
import com.github.wxiaoqi.security.auth.client.EnableAceAuthClient;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.scheduling.annotation.EnableScheduling;
import tk.mybatis.spring.annotation.MapperScan;

/**
 * @author libin
 * @version 1.0
 * @description 活动
 * @data 2019/6/14 11:19
 */
@SpringBootApplication(scanBasePackages = {
        "com.xxfc.platform",
        "com.github.wxiaoqi",
})
@EnableDiscoveryClient
@EnableScheduling
@EnableAceAuthClient
@EnableFeignClients({"com.github.wxiaoqi.security.auth.client.feign", "com.github.wxiaoqi.security.admin.feign","com.xxfc.platform"})
@EnableAceCache
@EnableCaching
@MapperScan(basePackages = "com.xxfc.platform.activity.mapper")
public class ActivityApplication {

    public static void main(String[] args) {
        SpringApplication.run(ActivityApplication.class, args);
    }
}
