package com.xxfc.platform.order.biz;

import cn.hutool.core.bean.BeanUtil;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.order.contant.enumerate.OrderStatusEnum;
import com.xxfc.platform.order.entity.BaseOrder;
import com.xxfc.platform.order.mapper.OrderTourVerificationMapper;
import com.xxfc.platform.order.pojo.order.OrderTourVerificationVO;
import com.xxfc.platform.tour.feign.TourFeign;
import com.xxfc.platform.tour.vo.TourGoodOrderFindVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 旅游订单核销
 *
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-06 18:18:33
 */
@Service
public class OrderTourVerificationBiz{


    @Autowired
    private OrderTourVerificationMapper verificationMapper;
    @Autowired
    private BaseOrderBiz baseOrderBiz;
    @Autowired
    private TourFeign tourFeign;

    /**
     * 分页查询旅游订单核销列表
     * @param page
     * @param limit
     * @return
     */
    public PageDataVO<OrderTourVerificationVO> getVerificationList(Integer page, Integer limit,Integer verificationId){

        return  PageDataVO.pageInfo(page,limit,()->verificationMapper.pageByParm(verificationId));
    }

    //核销
    public ObjectRestResponse VerificationByOrder(Integer orderId){
        BaseOrder baseOrder=baseOrderBiz.selectById(orderId);
        if(baseOrder==null){
            return ObjectRestResponse.createFailedResult(ResultCode.NULL_CODE, "订单不存在");
        }
        if(baseOrder.getStatus()!=OrderStatusEnum.ORDER_TOSTART.getCode()){
            return ObjectRestResponse.createFailedResult(ResultCode.NULL_CODE, "订单不是已支付状态");
        }
        baseOrder=new BaseOrder();
        baseOrder.setId(orderId);
        baseOrder.setStatus(OrderStatusEnum.ORDER_FINISH.getCode());
        baseOrderBiz.updateSelectiveById(baseOrder);
         return  ObjectRestResponse.succ();
    }

    //确定上车
    public ObjectRestResponse finishByOrder(Integer verificationId){

        return  ObjectRestResponse.succ(tourFeign.updateTourGoodVerificationStatus(verificationId));
    }

    //核销列表
    public ObjectRestResponse getVerifications(TourGoodOrderFindVo tourGoodOrderFindVo){

        return  ObjectRestResponse.succ(tourFeign.findTourGoodOrders(BeanUtil.beanToMap(tourGoodOrderFindVo)));
    }





}