package com.github.wxiaoqi.security.admin.rest;

import com.github.wxiaoqi.security.admin.biz.UserMemberLevelBiz;
import com.github.wxiaoqi.security.admin.entity.BaseUserMemberLevel;
import io.swagger.models.auth.In;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * ${DESCRIPTION}
 *
 * @author wanghaobin
 * @create 2017-06-08 11:51
 */
@RestController
@RequestMapping("member")
public class MemberLevelController {

    @Autowired
    private UserMemberLevelBiz memberBiz;

    @RequestMapping(value = "/app/unauth/levels", method = RequestMethod.GET)
    public @ResponseBody
    List<BaseUserMemberLevel> levels() throws Exception {
        return memberBiz.getLevesls();
    }

    @RequestMapping(value = "/app/unauth/level/{type}", method = RequestMethod.GET)
    public @ResponseBody
    BaseUserMemberLevel level(@PathVariable Integer type) throws Exception {
         List<BaseUserMemberLevel> list=memberBiz.getLevesls();
         if(type!=null){
             if(list.size()>0){
                 for (BaseUserMemberLevel userMemberLevel:list){
                     if(userMemberLevel.getLevel()!=null&&userMemberLevel.getLevel()==type){
                         return userMemberLevel;
                     }
                 }
             }
         }
        return null;
    }
}
