package com.github.wxiaoqi.security.admin.rest.admin;

import com.github.wxiaoqi.security.admin.biz.AppUserPositionBiz;
import com.github.wxiaoqi.security.admin.dto.UserPostionDTO;
import com.github.wxiaoqi.security.admin.vo.WalletPostionVo;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/17 16:13
 */
@RestController
@RequestMapping("/postion/admin")
public class AppUserPositionController {

     @Autowired
    private AppUserPositionBiz appUserPositionBiz;

     @GetMapping("/postions")
     public ObjectRestResponse<List<WalletPostionVo>> findAllPostions(){
          List<WalletPostionVo> walletPostionVos  = appUserPositionBiz.findAllPostions();
         return ObjectRestResponse.succ(walletPostionVos);
     }

     @PutMapping
     public ObjectRestResponse updateUserPostionPercentage(@RequestBody List<UserPostionDTO> userPostionDTOS){
         appUserPositionBiz.updateUserPostionPercentage(userPostionDTOS);
         return ObjectRestResponse.succ();
     }
}
