package com.xxfc.platform.vehicle.constant;

import java.util.HashMap;
import java.util.Map;

public enum  BranchCompanyStatus {
    PREPARING(1,"筹备中"),
    SOFT_OPING(2,"试业中"),
    ADD_SELECTION(3,"选址中"),
    OPEN(4,"已开业"),
    RENOVATION(5,"装修中"),
    ;
    /**
     * 编码
     */
    private Integer code;
    /**
     * 类型描述
     */
    private String desc;

    private static Map<Integer,String> codeAndDesc = new HashMap<Integer, String>();
            //Maps.newHashMap();

    static{
        for(VehicleBookRecordStatus constantType : VehicleBookRecordStatus.values()){
            codeAndDesc.put(constantType.getCode(),constantType.getDesc());
        }
    }

    BranchCompanyStatus(Integer code, String desc){
        this.code=code;
        this.desc=desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static Boolean exists(Integer code){
        return codeAndDesc.containsKey(code);
    }
}
