package com.xxfc.platform.tour.rest;

import cn.hutool.core.bean.BeanUtil;
import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.github.wxiaoqi.security.common.vo.PageParam;
import com.xxfc.platform.tour.biz.TourTagBiz;
import com.xxfc.platform.tour.entity.TourTag;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.Data;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import java.util.List;

@RestController
@RequestMapping("tourTag")
public class TourTagController extends BaseController<TourTagBiz,TourTag> {

    @Autowired
    private TourTagBiz tagBiz;

    @GetMapping("/app/unauth/getTagList")
    public ObjectRestResponse getTagList(pageDTO dto){

        if (dto==null) {
            return ObjectRestResponse.createDefaultFail();
        }

        Integer hot = dto.getHot();



        if (hot==1){
            List<TourTag> hotTag = tagBiz.getHotTag();
            return ObjectRestResponse.succ(hotTag);
        }


        PageDataVO<TourTag> all = tagBiz.findPage(BeanUtil.beanToMap(dto));

        return ObjectRestResponse.succ(all);

    }


    @Override
    @ApiOperation("修改")
    @RequestMapping(value = "/{id}",method = RequestMethod.PUT)
    public ObjectRestResponse<TourTag> update(@RequestBody TourTag tag){
        tagBiz.update(tag);
        return new ObjectRestResponse<TourTag>();
    }



    @Override
    @ApiOperation("删除")
    @RequestMapping(value = "/{id}",method = RequestMethod.DELETE)
    public ObjectRestResponse<TourTag> remove(@PathVariable int id){
        tagBiz.remove(id);
        return new ObjectRestResponse<TourTag>();
    }


    @Data
    public class pageDTO extends PageParam {
        @ApiModelProperty("是否热门")
        Integer hot;
    }


    @GetMapping("/token")
    public ObjectRestResponse apptoken(AppUserDTO appUserDTO){

        return ObjectRestResponse.succ(appUserDTO);
    }

}