package com.xxfc.platform.order.pojo.mq;

import com.xxfc.platform.order.contant.enumerate.ItemTypeEnum;
import com.xxfc.platform.order.entity.*;
import com.xxfc.platform.order.entity.inter.OrderDetail;
import com.xxfc.platform.order.entity.inter.OrderItemInter;
import lombok.Data;

import java.util.List;

@Data
public class OrderMQDTO extends BaseOrder implements OrderItemInter {

    public static final int ORDER_CRT = 1;
    public static final int ORDER_CANCEL = 2;
    public static final int ORDER_PAY = 4;
    public static final int ORDER_FINISH = 6;
    public static final int ORDER_PART_DEPOSIT = 101;

    OrderRentVehicleDetail orderRentVehicleDetail;

    OrderTourDetail orderTourDetail;

    OrderMemberDetail orderMemberDetail;

    List<OrderItem> items;

    public OrderItem getItemByTypeEnum(ItemTypeEnum itemTypeEnum) {
        for(OrderItem item: items) {
            if(itemTypeEnum.getCode().equals(item.getType())) {
                return item;
            }
        }
        return null;
    }

    /**
     * 标记是什么操作
     * 0--删除"
     * 1--创建订单"
     * 2--取消"
     *
     * 4--已支付"
     *
     * 6--已完成
     *
     * 101--部分押金退还
     */
    Integer sign;
}
