package com.xxfc.platform.order.Utils;

import org.joda.time.DateTime;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;

public class OrderDateUtils {

    public static String getFirstDayOfMonth(int year, int month) {
        String monthStr = String.valueOf(month);
        return year + "-" + monthStr + "-" + "01";
    }

    /**
     *  get the last date of given month and year
     *  @param year
     *  @param month
     *  @return
     *     
     */


    public static  String getLastDayOfMonth(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.YEAR, year);
        calendar.set(Calendar.MONTH, month - 1);
        calendar.set(Calendar.DATE, 1);
        calendar.add(Calendar.MONTH, 1);
        calendar.add(Calendar.DAY_OF_YEAR, -1);
        return calendar.get(Calendar.YEAR) + "-" + (calendar.get(Calendar.MONTH) + 1) + "-" +
                calendar.get(Calendar.DAY_OF_MONTH);
    }

    /**
     *  get Calendar of given year
     *  @param year
     *  @return
     *     
     */


    private static Calendar getCalendarFormYear(int year) {
        Calendar cal = Calendar.getInstance();
        cal.set(Calendar.DAY_OF_WEEK, Calendar.MONDAY);
        cal.set(Calendar.YEAR, year);
        return cal;
    }

    /**
     *  get start date of given week no of a year
     *  @param year
     *  @param weekNo
     *  @return
     *     
     */


    public static  String getStartDayOfWeekNo(int year, int weekNo) {
        Calendar cal = getCalendarFormYear(year);
        cal.set(Calendar.WEEK_OF_YEAR, weekNo);
        return cal.get(Calendar.YEAR) + "-" + (cal.get(Calendar.MONTH) + 1) + "-" +
                cal.get(Calendar.DAY_OF_MONTH);

    }

    /**
     *  get the end day of given week no of a year.
     *  @param year
     *  @param weekNo
     *  @return
     *     
     */
    public static String getEndDayOfWeekNo(int year, int weekNo) {
        Calendar cal = getCalendarFormYear(year);
        cal.set(Calendar.WEEK_OF_YEAR, weekNo);
        cal.add(Calendar.DAY_OF_WEEK, 6);
        return cal.get(Calendar.YEAR) + "-" + (cal.get(Calendar.MONTH) + 1) + "-" +
                cal.get(Calendar.DAY_OF_MONTH);
    }

    public static String timeStampConversionToString(Long time) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date date = new Date(time);
        return simpleDateFormat.format(date);
    }

    public static Long ConvertingStringsToTimestamps(String time) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return simpleDateFormat.parse(time).getTime();
    }

    public static Integer getTodayOfWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(Calendar.MONDAY);
        cal.setTimeInMillis(System.currentTimeMillis());
        return cal.get(Calendar.WEEK_OF_YEAR);
    }

    public static Integer getTodayOfMonth() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(System.currentTimeMillis());
        return cal.get(Calendar.MONTH)+1;
    }

    public static Integer getThisYear() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(System.currentTimeMillis());
        return cal.get(Calendar.YEAR);
    }

        public static LocalDate dateToLocalDate(Date date) {
            return LocalDate.from(date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
        }

        public static Date localDateToDate(LocalDate localDate) {
            return Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
        }

        /**
         * 获取当天的开始时间
         * @return
         */
        public static long getStartOfDay() {
            return getStartOfDay(new Date());
        }

        /**
         * 获取某天的开始时间
         * @param date
         * @return
         */
        public static long getStartOfDay(Date date) {
            DateTime dateTime = new DateTime(date);
            DateTime startOfDay = dateTime.withTimeAtStartOfDay();
            return startOfDay.getMillis();
        }

        /**
         * 获取当天的结束时间
         * @return
         */
        public static long getEndOfDay() {
            return getEndOfDay(new Date());
        }

        /**
         * 获取某天的结束时间
         * @param date
         * @return
         */
        public static long getEndOfDay(Date date) {
            DateTime dateTime = new DateTime(date);
            DateTime endOfDay = dateTime.millisOfDay().withMaximumValue();
            return endOfDay.getMillis();
        }

}
