package com.xxfc.platform.app.rest;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.xxfc.platform.app.biz.CofigBiz;
import com.xxfc.platform.app.entity.Cofig;
import com.xxfc.platform.app.entity.vo.WithDrawRuleVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("cofig")
@IgnoreClientToken
@Slf4j
public class CofigController extends BaseController<CofigBiz,Cofig> {


    @RequestMapping(value ="/app/unauth/types",method = RequestMethod.GET)
    @IgnoreUserToken
    public ObjectRestResponse<List<Cofig>> getAllByType(@RequestParam(value = "types",defaultValue = "") String types){
        if(StringUtils.isBlank(types)){
            throw new BaseException(ResultCode.NULL_CODE);
        }
        String[] all=types.split(",");
        List<Integer>list=new ArrayList<>();
        for (String str:all){
            if(StringUtils.isNotBlank(str)){
                list.add(Integer.parseInt(str));
            }
        }
        return  new ObjectRestResponse<>().rel(true).data(baseBiz.getConfigByType(list));
    }

    @GetMapping("/app/unauth/withdraw_rule")
    @IgnoreUserToken
    public WithDrawRuleVo getWithDrawRule(){
        return  baseBiz.getWithDrawRule();
    }



    @GetMapping("/app/unauth/wallet_rule")
    @IgnoreUserToken
    public ObjectRestResponse getWalletRule(){
        return  ObjectRestResponse.succ(baseBiz.getWithDrawRule());
    }
}