package com.github.wxiaoqi.security.admin.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 我的收藏
 */
@Table(name = "app_user_collect")
@Data
public class AppUserCollect {
    @Id
    @ApiModelProperty("主键id")
    @GeneratedValue(generator = "JDBC")
    private Integer id;

    @ApiModelProperty("用户id")
    @Column(name = "user_id")
    private Integer userId;

    @ApiModelProperty("收藏类型;1-租车；2-旅游")
    @Column(name = "type")
    private Integer type;

    @ApiModelProperty("类型id")
    @Column(name = "type_id")
    private Integer typeId;

    @ApiModelProperty("类型id名称")
    @Column(name = "name")
    private String name;

    @ApiModelProperty("封面")
    @Column(name = "cover")
    private String cover;

    @ApiModelProperty("价格")
    @Column(name = "price")
    private BigDecimal price;

    @ApiModelProperty("单位")
    @Column(name = "unit")
    private String unit;



    @ApiModelProperty("创建时间")
    @Column(name = "crt_time")
    private Long crtTime;



    @ApiModelProperty("更新时间")
    @Column(name = "upd_time")
    private Long updTime;


    @ApiModelProperty("否取消；0-正常；1-取消")
    @Column(name = "status")
    private Integer status;

    @ApiModelProperty("否取消；0-正常；1-取消")
    @Column(name = "is_del")
    private Integer isDel;



}