

CREATE DATABASE ag_nacos DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;
Use ag_nacos;/*
 Navicat Premium Data Transfer

 Source Server         : localhost
 Source Server Type    : MySQL
 Source Server Version : 50718
 Source Host           : localhost
 Source Database       : ag_nacos

 Target Server Type    : MySQL
 Target Server Version : 50718
 File Encoding         : utf-8

 Date: 02/05/2019 21:40:46 PM
*/

SET NAMES utf8;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
--  Table structure for `config_info`
-- ----------------------------
DROP TABLE IF EXISTS `config_info`;
CREATE TABLE `config_info` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `data_id` varchar(255) COLLATE utf8_bin NOT NULL COMMENT 'data_id',
  `group_id` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `content` longtext COLLATE utf8_bin NOT NULL COMMENT 'content',
  `md5` varchar(32) COLLATE utf8_bin DEFAULT NULL COMMENT 'md5',
  `gmt_create` datetime NOT NULL DEFAULT '2010-05-05 00:00:00' COMMENT '创建时间',
  `gmt_modified` datetime NOT NULL DEFAULT '2010-05-05 00:00:00' COMMENT '修改时间',
  `src_user` text COLLATE utf8_bin COMMENT 'source user',
  `src_ip` varchar(20) COLLATE utf8_bin DEFAULT NULL COMMENT 'source ip',
  `app_name` varchar(128) COLLATE utf8_bin DEFAULT NULL,
  `tenant_id` varchar(128) COLLATE utf8_bin DEFAULT '' COMMENT '租户字段',
  `c_desc` varchar(256) COLLATE utf8_bin DEFAULT NULL,
  `c_use` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `effect` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `type` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `c_schema` text COLLATE utf8_bin,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_configinfo_datagrouptenant` (`data_id`,`group_id`,`tenant_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='config_info';

-- ----------------------------
--  Records of `config_info`
-- ----------------------------
BEGIN;
INSERT INTO `config_info` VALUES ('1', 'ace-auth-dev.yaml', 'DEFAULT_GROUP', 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, 'e991ab23752535fb5aa0a75b42bb6fa5', '2019-01-27 09:59:33', '2019-01-27 09:59:33', null, '0:0:0:0:0:0:0:1', '', '', null, null, null, 'yaml', null), ('2', 'ace-admin-dev.yaml', 'DEFAULT_GROUP', 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, '8a70da456f86dfb53253351ab9e4d42e', '2019-01-27 10:00:09', '2019-01-27 10:00:09', null, '0:0:0:0:0:0:0:1', '', '', null, null, null, 'yaml', null), ('3', 'ace-gateway-dev.yaml', 'DEFAULT_GROUP', 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, 'eb8050d11dfea6bdf6516b85458095c2', '2019-01-27 10:00:37', '2019-01-27 13:10:10', null, '0:0:0:0:0:0:0:1', '', '', '', null, null, 'yaml', null);
COMMIT;

-- ----------------------------
--  Table structure for `config_info_aggr`
-- ----------------------------
DROP TABLE IF EXISTS `config_info_aggr`;
CREATE TABLE `config_info_aggr` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `data_id` varchar(255) COLLATE utf8_bin NOT NULL COMMENT 'data_id',
  `group_id` varchar(255) COLLATE utf8_bin NOT NULL COMMENT 'group_id',
  `datum_id` varchar(255) COLLATE utf8_bin NOT NULL COMMENT 'datum_id',
  `content` longtext COLLATE utf8_bin NOT NULL COMMENT '内容',
  `gmt_modified` datetime NOT NULL COMMENT '修改时间',
  `app_name` varchar(128) COLLATE utf8_bin DEFAULT NULL,
  `tenant_id` varchar(128) COLLATE utf8_bin DEFAULT '' COMMENT '租户字段',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_configinfoaggr_datagrouptenantdatum` (`data_id`,`group_id`,`tenant_id`,`datum_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='增加租户字段';

-- ----------------------------
--  Table structure for `config_info_beta`
-- ----------------------------
DROP TABLE IF EXISTS `config_info_beta`;
CREATE TABLE `config_info_beta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `data_id` varchar(255) COLLATE utf8_bin NOT NULL COMMENT 'data_id',
  `group_id` varchar(128) COLLATE utf8_bin NOT NULL COMMENT 'group_id',
  `app_name` varchar(128) COLLATE utf8_bin DEFAULT NULL COMMENT 'app_name',
  `content` longtext COLLATE utf8_bin NOT NULL COMMENT 'content',
  `beta_ips` varchar(1024) COLLATE utf8_bin DEFAULT NULL COMMENT 'betaIps',
  `md5` varchar(32) COLLATE utf8_bin DEFAULT NULL COMMENT 'md5',
  `gmt_create` datetime NOT NULL DEFAULT '2010-05-05 00:00:00' COMMENT '创建时间',
  `gmt_modified` datetime NOT NULL DEFAULT '2010-05-05 00:00:00' COMMENT '修改时间',
  `src_user` text COLLATE utf8_bin COMMENT 'source user',
  `src_ip` varchar(20) COLLATE utf8_bin DEFAULT NULL COMMENT 'source ip',
  `tenant_id` varchar(128) COLLATE utf8_bin DEFAULT '' COMMENT '租户字段',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_configinfobeta_datagrouptenant` (`data_id`,`group_id`,`tenant_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='config_info_beta';

-- ----------------------------
--  Table structure for `config_info_tag`
-- ----------------------------
DROP TABLE IF EXISTS `config_info_tag`;
CREATE TABLE `config_info_tag` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `data_id` varchar(255) COLLATE utf8_bin NOT NULL COMMENT 'data_id',
  `group_id` varchar(128) COLLATE utf8_bin NOT NULL COMMENT 'group_id',
  `tenant_id` varchar(128) COLLATE utf8_bin DEFAULT '' COMMENT 'tenant_id',
  `tag_id` varchar(128) COLLATE utf8_bin NOT NULL COMMENT 'tag_id',
  `app_name` varchar(128) COLLATE utf8_bin DEFAULT NULL COMMENT 'app_name',
  `content` longtext COLLATE utf8_bin NOT NULL COMMENT 'content',
  `md5` varchar(32) COLLATE utf8_bin DEFAULT NULL COMMENT 'md5',
  `gmt_create` datetime NOT NULL DEFAULT '2010-05-05 00:00:00' COMMENT '创建时间',
  `gmt_modified` datetime NOT NULL DEFAULT '2010-05-05 00:00:00' COMMENT '修改时间',
  `src_user` text COLLATE utf8_bin COMMENT 'source user',
  `src_ip` varchar(20) COLLATE utf8_bin DEFAULT NULL COMMENT 'source ip',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_configinfotag_datagrouptenanttag` (`data_id`,`group_id`,`tenant_id`,`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='config_info_tag';

-- ----------------------------
--  Table structure for `config_tags_relation`
-- ----------------------------
DROP TABLE IF EXISTS `config_tags_relation`;
CREATE TABLE `config_tags_relation` (
  `id` bigint(20) NOT NULL COMMENT 'id',
  `tag_name` varchar(128) COLLATE utf8_bin NOT NULL COMMENT 'tag_name',
  `tag_type` varchar(64) COLLATE utf8_bin DEFAULT NULL COMMENT 'tag_type',
  `data_id` varchar(255) COLLATE utf8_bin NOT NULL COMMENT 'data_id',
  `group_id` varchar(128) COLLATE utf8_bin NOT NULL COMMENT 'group_id',
  `tenant_id` varchar(128) COLLATE utf8_bin DEFAULT '' COMMENT 'tenant_id',
  `nid` bigint(20) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`nid`),
  UNIQUE KEY `uk_configtagrelation_configidtag` (`id`,`tag_name`,`tag_type`),
  KEY `idx_tenant_id` (`tenant_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='config_tag_relation';

-- ----------------------------
--  Table structure for `group_capacity`
-- ----------------------------
DROP TABLE IF EXISTS `group_capacity`;
CREATE TABLE `group_capacity` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `group_id` varchar(128) COLLATE utf8_bin NOT NULL DEFAULT '' COMMENT 'Group ID，空字符表示整个集群',
  `quota` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '配额，0表示使用默认值',
  `usage` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '使用量',
  `max_size` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '单个配置大小上限，单位为字节，0表示使用默认值',
  `max_aggr_count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '聚合子配置最大个数，，0表示使用默认值',
  `max_aggr_size` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '单个聚合数据的子配置大小上限，单位为字节，0表示使用默认值',
  `max_history_count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最大变更历史数量',
  `gmt_create` datetime NOT NULL DEFAULT '2010-05-05 00:00:00' COMMENT '创建时间',
  `gmt_modified` datetime NOT NULL DEFAULT '2010-05-05 00:00:00' COMMENT '修改时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_group_id` (`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='集群、各Group容量信息表';

-- ----------------------------
--  Table structure for `his_config_info`
-- ----------------------------
DROP TABLE IF EXISTS `his_config_info`;
CREATE TABLE `his_config_info` (
  `id` bigint(64) unsigned NOT NULL,
  `nid` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `data_id` varchar(255) COLLATE utf8_bin NOT NULL,
  `group_id` varchar(128) COLLATE utf8_bin NOT NULL,
  `app_name` varchar(128) COLLATE utf8_bin DEFAULT NULL COMMENT 'app_name',
  `content` longtext COLLATE utf8_bin NOT NULL,
  `md5` varchar(32) COLLATE utf8_bin DEFAULT NULL,
  `gmt_create` datetime NOT NULL DEFAULT '2010-05-05 00:00:00',
  `gmt_modified` datetime NOT NULL DEFAULT '2010-05-05 00:00:00',
  `src_user` text COLLATE utf8_bin,
  `src_ip` varchar(20) COLLATE utf8_bin DEFAULT NULL,
  `op_type` char(10) COLLATE utf8_bin DEFAULT NULL,
  `tenant_id` varchar(128) COLLATE utf8_bin DEFAULT '' COMMENT '租户字段',
  PRIMARY KEY (`nid`),
  KEY `idx_gmt_create` (`gmt_create`),
  KEY `idx_gmt_modified` (`gmt_modified`),
  KEY `idx_did` (`data_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='多租户改造';

-- ----------------------------
--  Records of `his_config_info`
-- ----------------------------
BEGIN;
INSERT INTO `his_config_info` VALUES ('0', '1', 'ace-auth-dev.yaml', 'DEFAULT_GROUP', '', 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, 'e991ab23752535fb5aa0a75b42bb6fa5', '2010-05-05 00:00:00', '2019-01-27 09:59:33', null, '0:0:0:0:0:0:0:1', 'I', ''), ('0', '2', 'ace-admin-dev.yaml', 'DEFAULT_GROUP', '', 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, '8a70da456f86dfb53253351ab9e4d42e', '2010-05-05 00:00:00', '2019-01-27 10:00:09', null, '0:0:0:0:0:0:0:1', 'I', ''), ('0', '3', 'ace-gateway-dev.yaml', 'DEFAULT_GROUP', '', 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, '2ba814f17be35a6b82c315a9249b4e67', '2010-05-05 00:00:00', '2019-01-27 10:00:37', null, '0:0:0:0:0:0:0:1', 'I', ''), ('3', '4', 'ace-gateway-dev.yaml', 'DEFAULT_GROUP', '', 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, '2ba814f17be35a6b82c315a9249b4e67', '2010-05-05 00:00:00', '2019-01-27 13:10:10', null, '0:0:0:0:0:0:0:1', 'U', '');
COMMIT;

-- ----------------------------
--  Table structure for `roles`
-- ----------------------------
DROP TABLE IF EXISTS `roles`;
CREATE TABLE `roles` (
  `username` varchar(50) NOT NULL,
  `role` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Records of `roles`
-- ----------------------------
BEGIN;
INSERT INTO `roles` VALUES ('nacos', 'ROLE_ADMIN');
COMMIT;

-- ----------------------------
--  Table structure for `tenant_capacity`
-- ----------------------------
DROP TABLE IF EXISTS `tenant_capacity`;
CREATE TABLE `tenant_capacity` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `tenant_id` varchar(128) COLLATE utf8_bin NOT NULL DEFAULT '' COMMENT 'Tenant ID',
  `quota` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '配额，0表示使用默认值',
  `usage` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '使用量',
  `max_size` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '单个配置大小上限，单位为字节，0表示使用默认值',
  `max_aggr_count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '聚合子配置最大个数',
  `max_aggr_size` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '单个聚合数据的子配置大小上限，单位为字节，0表示使用默认值',
  `max_history_count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最大变更历史数量',
  `gmt_create` datetime NOT NULL DEFAULT '2010-05-05 00:00:00' COMMENT '创建时间',
  `gmt_modified` datetime NOT NULL DEFAULT '2010-05-05 00:00:00' COMMENT '修改时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_tenant_id` (`tenant_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='租户容量信息表';

-- ----------------------------
--  Table structure for `tenant_info`
-- ----------------------------
DROP TABLE IF EXISTS `tenant_info`;
CREATE TABLE `tenant_info` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `kp` varchar(128) COLLATE utf8_bin NOT NULL COMMENT 'kp',
  `tenant_id` varchar(128) COLLATE utf8_bin DEFAULT '' COMMENT 'tenant_id',
  `tenant_name` varchar(128) COLLATE utf8_bin DEFAULT '' COMMENT 'tenant_name',
  `tenant_desc` varchar(256) COLLATE utf8_bin DEFAULT NULL COMMENT 'tenant_desc',
  `create_source` varchar(32) COLLATE utf8_bin DEFAULT NULL COMMENT 'create_source',
  `gmt_create` bigint(20) NOT NULL COMMENT '创建时间',
  `gmt_modified` bigint(20) NOT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_tenant_info_kptenantid` (`kp`,`tenant_id`),
  KEY `idx_tenant_id` (`tenant_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='tenant_info';

-- ----------------------------
--  Table structure for `users`
-- ----------------------------
DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `username` varchar(50) NOT NULL,
  `password` varchar(500) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  PRIMARY KEY (`username`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Records of `users`
-- ----------------------------
BEGIN;
INSERT INTO `users` VALUES ('nacos', '$2a$10$EuWPZHzz32dJN7jexM34MOeYirDdFAZm2kuWj7VEOJhhZkDrxfvUu', '1');
COMMIT;

SET FOREIGN_KEY_CHECKS = 1;
