package com.github.wxiaoqi.security.common.util;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;

/**
 * 随机数工具
 * @author Deacon
 *
 */
public class RandomUtil 
{
	/**
	 * 获取随机数
	 * 
	 * @param length 随机数长度
	 * @return
	 */
	public static String getRandomStr(int length) 
	{
		// 根据长度, 计算需要相乘的数
		int num = 1;
		for (int i = 0; i < length; i++) {
			num = num * 10;
		}

		// 保证随机数大于0.1
		double random = Math.random();
		if (random < 0.1) {
			random = random + 0.1;
		}

		return String.valueOf((int) (random * num));
	}

	/**
	 * 获取随机数字集合
	 * @param max
	 * @param n
	 * @param set
	 */
	public static void randomSet(int max, int n, Set<Integer> set, int total) {
		if (n > (max) || max < 0) {
			return;
		}
		for (int i = 0; i < n; i++) {
			int num = (int) (Math.random() * (max));
			set.add(num);
		}
		int setSize = set.size();
		// 如果存入的数小于指定生成的个数，则调用递归再生成剩余个数的随机数，如此循环，直到达到指定大小
		if (setSize < total) {
			randomSet(max, total - setSize, set, total);// 递归
		}
	}

	public static synchronized String gencRan(){
		Random ran = new Random(System.nanoTime());
		double nextDouble = ran.nextDouble();
		return String.valueOf(nextDouble).substring(2, 6);
	}

	public static void main(String[] args) {
		int max = 20;
		int n = 30;
		Set<Integer> set = new HashSet<>();
		randomSet(max, n, set, n);
		for(Integer a : set) {
			System.out.println(a);
		}
	}
}
