package com.xxfc.platform.vehicle.rest.admin;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.vehicle.biz.CompanyBaseBiz;
import com.xxfc.platform.vehicle.common.BaseController;
import com.xxfc.platform.vehicle.entity.BranchCompany;
import com.xxfc.platform.vehicle.pojo.vo.CompanyVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;

@RestController
@IgnoreClientToken
@IgnoreUserToken
@RequestMapping("company/base")
public class CompanyController extends BaseController<CompanyBaseBiz> {


    @ApiOperation("同步分公司信息")
    @PostMapping("synchro")
    public ObjectRestResponse synchro()throws  Exception {
        return baseBiz.synchro4();
    }

    @ApiOperation("同步分公司地址")
    @PostMapping("synchro2")
    public ObjectRestResponse<String> synchro2() {
        return baseBiz.synchro2();
    }

    @ApiOperation("同步股权3")
    @PostMapping("synchro3")
    public ObjectRestResponse synchro3() {
        return baseBiz.synchro6();
    }


    @ApiOperation("查询公司列表")
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public ObjectRestResponse getList(CompanyVo companyVo){
        return  baseBiz.getList(companyVo);
    }

    @ApiOperation("设置基础信息")
    @RequestMapping(value = "/updCompany", method = RequestMethod.POST)
    public ObjectRestResponse updCompany(@RequestBody CompanyVo companyVo){
        return  baseBiz.updCompany(companyVo);
    }

    @ApiOperation("添加分公司")
    @RequestMapping(value = "/addCompany", method = RequestMethod.POST)
    public ObjectRestResponse addCompany(@RequestBody CompanyVo companyVo){
        return  baseBiz.updCompany(companyVo);
    }

    @ApiOperation("获取详情")
    @RequestMapping(value = "/getCompanyDetail", method = RequestMethod.GET)
    public ObjectRestResponse getCompanyDetail(CompanyVo companyVo){
        return  baseBiz.getCompanyDetail(companyVo);
    }

    @ApiOperation("设置股权信息")
    @RequestMapping(value = "/updStockInfo", method = RequestMethod.POST)
    public ObjectRestResponse updStockInfo(@RequestBody CompanyVo companyVo){
        return  baseBiz.updStockInfo(companyVo);
    }
    @ApiOperation("设置详情")
    @RequestMapping(value = "/updCompanyDetail", method = RequestMethod.POST)
    public ObjectRestResponse updCompanyDetail(@RequestBody CompanyVo companyVo){
        return  baseBiz.updCompanyDetail(companyVo);
    }

    @ApiOperation("删除")
    @RequestMapping(value = "/del", method = RequestMethod.POST)
    public ObjectRestResponse del(@RequestBody CompanyVo companyVo){
        return  baseBiz.delCompany(companyVo.getId());
    }

    /**
     * 导入
     * @param multipartfile
     * @param request
     * @return
     */
    @PostMapping("app/unauth/importExcel")
    public ObjectRestResponse importExcel(@RequestParam(value = "file") MultipartFile multipartfile,
                                    HttpServletRequest request) {
        return baseBiz.importExcel(multipartfile,request);
    }

    @ApiOperation("获取分公司")
    @GetMapping("app/unauth/companyId")
    public BranchCompany companyId(@RequestParam(value = "name") String name) {
        return baseBiz.getCompanyId(name);
    }




}
