package com.xxfc.platform.vehicle.constant;

import java.util.HashMap;
import java.util.Map;

public enum VehicleMsgType {
    MAINTENANCE(1,"汽车保养提醒"),
    REPAIR(2,"汽车维修提醒"),
    CUSTOM(3,"自定义"),
    ;
    /**
     * 编码
     */
    private Integer code;
    /**
     * 类型描述
     */
    private String desc;

    private static Map<Integer,String> codeAndDesc = new HashMap<Integer, String>();
            //Maps.newHashMap();

    static{
        for(VehicleMsgType constantType : VehicleMsgType.values()){
            codeAndDesc.put(constantType.getCode(),constantType.getDesc());
        }
    }

    VehicleMsgType(Integer code, String desc){
        this.code=code;
        this.desc=desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static Boolean exists(Integer code){
        return codeAndDesc.containsKey(code);
    }

}
